/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.util;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.capability.NetworkNodeProxyCapability;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetworkUtils {
    @Nullable
    public static INetworkNode getNodeFromTile(@Nullable TileEntity tile) {
        INetworkNodeProxy proxy;
        if (tile != null && (proxy = (INetworkNodeProxy)tile.getCapability(NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY).orElse(null)) != null) {
            return proxy.getNode();
        }
        return null;
    }

    @Nullable
    public static INetwork getNetworkFromNode(@Nullable INetworkNode node) {
        if (node != null) {
            return node.getNetwork();
        }
        return null;
    }

    public static ActionResultType attemptModify(World world, BlockPos pos, Direction facing, PlayerEntity player, Runnable action) {
        return NetworkUtils.attempt(world, pos, facing, player, action, Permission.MODIFY);
    }

    public static ActionResultType attempt(World world, BlockPos pos, Direction facing, PlayerEntity player, Runnable action, Permission ... permissionsRequired) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        INetwork network = NetworkUtils.getNetworkFromNode(NetworkUtils.getNodeFromTile(world.func_175625_s(pos)));
        if (network != null) {
            for (Permission permission : permissionsRequired) {
                if (network.getSecurityManager().hasPermission(permission, player)) continue;
                WorldUtils.sendNoPermissionMessage(player);
                return ActionResultType.SUCCESS;
            }
        }
        action.run();
        return ActionResultType.SUCCESS;
    }

    public static void extractBucketFromPlayerInventoryOrNetwork(PlayerEntity player, INetwork network, Consumer<ItemStack> onBucketFound) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack slot = player.field_71071_by.func_70301_a(i);
            if (!API.instance().getComparer().isEqualNoQuantity(StackUtils.EMPTY_BUCKET, slot)) continue;
            player.field_71071_by.func_70298_a(i, 1);
            onBucketFound.accept(StackUtils.EMPTY_BUCKET.func_77946_l());
            return;
        }
        ItemStack fromNetwork = network.extractItem(StackUtils.EMPTY_BUCKET, 1, Action.PERFORM);
        if (!fromNetwork.func_190926_b()) {
            onBucketFound.accept(fromNetwork);
        }
    }
}

