/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.capability.NetworkNodeProxyCapability;
import com.raoulvdberge.refinedstorage.tile.BaseTile;
import com.raoulvdberge.refinedstorage.tile.config.IRedstoneConfigurable;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class NetworkNodeTile<N extends NetworkNode>
extends BaseTile
implements INetworkNodeProxy<N>,
IRedstoneConfigurable {
    public static final TileDataParameter<Integer, NetworkNodeTile> REDSTONE_MODE = RedstoneMode.createParameter();
    private N clientNode;
    private N removedNode;
    private LazyOptional<INetworkNodeProxy<N>> networkNodeProxy = LazyOptional.of(() -> this);

    public NetworkNodeTile(TileEntityType<?> tileType) {
        super(tileType);
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return ((NetworkNode)this.getNode()).getRedstoneMode();
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        ((NetworkNode)this.getNode()).setRedstoneMode(mode);
    }

    @Override
    @Nonnull
    public N getNode() {
        if (this.field_145850_b.field_72995_K) {
            if (this.clientNode == null) {
                this.clientNode = this.createNode(this.field_145850_b, this.field_174879_c);
            }
            return this.clientNode;
        }
        INetworkNodeManager manager = API.instance().getNetworkNodeManager((ServerWorld)this.field_145850_b);
        INetworkNode node = manager.getNode(this.field_174879_c);
        if (node == null) {
            throw new RuntimeException("No network node present at " + this.field_174879_c.toString() + ", consider removing the block at this position");
        }
        return (N)((NetworkNode)node);
    }

    public void func_145829_t() {
        INetworkNodeManager manager;
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && (manager = API.instance().getNetworkNodeManager((ServerWorld)this.field_145850_b)).getNode(this.field_174879_c) == null) {
            manager.setNode(this.field_174879_c, (INetworkNode)this.createNode(this.field_145850_b, this.field_174879_c));
            manager.markForSaving();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            INetworkNodeManager manager = API.instance().getNetworkNodeManager((ServerWorld)this.field_145850_b);
            INetworkNode node = manager.getNode(this.field_174879_c);
            if (node != null) {
                this.removedNode = (NetworkNode)node;
            }
            manager.removeNode(this.field_174879_c);
            manager.markForSaving();
            if (node != null && node.getNetwork() != null) {
                node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, node.getNetwork().getWorld(), node.getNetwork().getPosition());
            }
        }
    }

    public N getRemovedNode() {
        return this.removedNode;
    }

    public abstract N createNode(World var1, BlockPos var2);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY) {
            return this.networkNodeProxy.cast();
        }
        return super.getCapability(cap, direction);
    }
}

