/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.DiskState;
import com.raoulvdberge.refinedstorage.block.DiskManipulatorBlock;
import com.raoulvdberge.refinedstorage.render.model.DelegateBakedModel;
import com.raoulvdberge.refinedstorage.render.model.TRSRBakedModel;
import com.raoulvdberge.refinedstorage.tile.DiskManipulatorTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;

public class DiskManipulatorBakedModel
extends DelegateBakedModel {
    private Map<Direction, IBakedModel> modelsConnected = new HashMap<Direction, IBakedModel>();
    private Map<Direction, IBakedModel> modelsDisconnected = new HashMap<Direction, IBakedModel>();
    private Map<Direction, Map<DiskState, List<IBakedModel>>> disks = new HashMap<Direction, Map<DiskState, List<IBakedModel>>>();
    private LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            Direction facing = (Direction)key.state.func_177229_b((IProperty)RSBlocks.DISK_MANIPULATOR.getDirection().getProperty());
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(((IBakedModel)((Boolean)key.state.func_177229_b((IProperty)DiskManipulatorBlock.CONNECTED) != false ? DiskManipulatorBakedModel.this.modelsConnected : DiskManipulatorBakedModel.this.modelsDisconnected).get(facing)).func_200117_a(key.state, key.side, key.random));
            for (int i = 0; i < 6; ++i) {
                if (key.diskState[i] == DiskState.NONE) continue;
                quads.addAll(((IBakedModel)((List)((Map)DiskManipulatorBakedModel.this.disks.get(facing)).get((Object)key.diskState[i])).get(i)).func_200117_a(key.state, key.side, key.random));
            }
            return quads;
        }
    });

    public DiskManipulatorBakedModel(IBakedModel baseConnected, IBakedModel baseDisconnected, IBakedModel disk, IBakedModel diskNearCapacity, IBakedModel diskFull, IBakedModel diskDisconnected) {
        super(baseDisconnected);
        for (Direction facing : Direction.values()) {
            if (facing.func_176736_b() == -1) continue;
            this.modelsConnected.put(facing, new TRSRBakedModel(baseConnected, facing));
            this.modelsDisconnected.put(facing, new TRSRBakedModel(baseDisconnected, facing));
            this.disks.put(facing, new HashMap());
            this.disks.get(facing).put(DiskState.NORMAL, new ArrayList());
            this.disks.get(facing).put(DiskState.NEAR_CAPACITY, new ArrayList());
            this.disks.get(facing).put(DiskState.FULL, new ArrayList());
            this.disks.get(facing).put(DiskState.DISCONNECTED, new ArrayList());
            this.addDiskModels(disk, DiskState.NORMAL, facing);
            this.addDiskModels(diskNearCapacity, DiskState.NEAR_CAPACITY, facing);
            this.addDiskModels(diskFull, DiskState.FULL, facing);
            this.addDiskModels(diskDisconnected, DiskState.DISCONNECTED, facing);
        }
    }

    private void addDiskModels(IBakedModel disk, DiskState type, Direction facing) {
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 3; ++y) {
                TRSRBakedModel model = new TRSRBakedModel(disk, facing);
                Vector3f trans = model.transformation.getTranslation();
                if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                    trans.func_195904_b((0.125f + (float)x * 7.0f / 16.0f) * (float)(facing == Direction.NORTH ? -1 : 1), 0.0f, 0.0f);
                } else if (facing == Direction.EAST || facing == Direction.WEST) {
                    trans.func_195904_b(0.0f, 0.0f, (0.125f + (float)x * 7.0f / 16.0f) * (float)(facing == Direction.EAST ? -1 : 1));
                }
                trans.func_195904_b(0.0f, -(0.375f + 3.0f * (float)y / 16.0f), 0.0f);
                model.transformation = new TransformationMatrix(trans, model.transformation.func_227989_d_(), model.transformation.getScale(), model.transformation.getRightRot());
                this.disks.get(facing).get((Object)type).add(model);
            }
        }
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
        DiskState[] diskState = (DiskState[])data.getData(DiskManipulatorTile.DISK_STATE_PROPERTY);
        if (diskState == null) {
            return this.base.getQuads(state, side, rand, data);
        }
        CacheKey key = new CacheKey(state, side, diskState, rand);
        return (List)this.cache.getUnchecked((Object)key);
    }

    private class CacheKey {
        private BlockState state;
        private Direction side;
        private DiskState[] diskState;
        private Random random;

        CacheKey(@Nullable BlockState state, Direction side, DiskState[] diskState, Random random) {
            this.state = state;
            this.side = side;
            this.diskState = diskState;
            this.random = random;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.state.equals(cacheKey.state)) {
                return false;
            }
            if (this.side != cacheKey.side) {
                return false;
            }
            return Arrays.equals((Object[])this.diskState, (Object[])cacheKey.diskState);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + Arrays.hashCode((Object[])this.diskState);
            return result;
        }
    }
}

