/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network.grid;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.GridContainer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class GridItemInsertHeldMessage {
    private boolean single;

    public GridItemInsertHeldMessage(boolean single) {
        this.single = single;
    }

    public static GridItemInsertHeldMessage decode(PacketBuffer buf) {
        return new GridItemInsertHeldMessage(buf.readBoolean());
    }

    public static void encode(GridItemInsertHeldMessage message, PacketBuffer buf) {
        buf.writeBoolean(message.single);
    }

    public static void handle(GridItemInsertHeldMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                IGrid grid;
                Container container = player.field_71070_bA;
                if (container instanceof GridContainer && (grid = ((GridContainer)container).getGrid()).getItemHandler() != null) {
                    grid.getItemHandler().onInsertHeldItem(player, message.single);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

