/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network.grid;

import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.network.ClientProxy;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class GridCraftingPreviewResponseMessage {
    private ResourceLocation factoryId;
    private List<ICraftingPreviewElement> stacks;
    private UUID id;
    private int quantity;
    private boolean fluids;

    public GridCraftingPreviewResponseMessage(ResourceLocation factoryId, List<ICraftingPreviewElement> stacks, UUID id, int quantity, boolean fluids) {
        this.factoryId = factoryId;
        this.stacks = stacks;
        this.id = id;
        this.quantity = quantity;
        this.fluids = fluids;
    }

    public ResourceLocation getFactoryId() {
        return this.factoryId;
    }

    public List<ICraftingPreviewElement> getStacks() {
        return this.stacks;
    }

    public UUID getId() {
        return this.id;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean isFluids() {
        return this.fluids;
    }

    public static GridCraftingPreviewResponseMessage decode(PacketBuffer buf) {
        ResourceLocation factoryId = buf.func_192575_l();
        UUID id = buf.func_179253_g();
        int quantity = buf.readInt();
        boolean fluids = buf.readBoolean();
        LinkedList<ICraftingPreviewElement> stacks = new LinkedList<ICraftingPreviewElement>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation type = buf.func_192575_l();
            stacks.add(API.instance().getCraftingPreviewElementRegistry().get(type).apply(buf));
        }
        return new GridCraftingPreviewResponseMessage(factoryId, stacks, id, quantity, fluids);
    }

    public static void encode(GridCraftingPreviewResponseMessage message, PacketBuffer buf) {
        buf.func_192572_a(message.factoryId);
        buf.func_179252_a(message.id);
        buf.writeInt(message.quantity);
        buf.writeBoolean(message.fluids);
        buf.writeInt(message.stacks.size());
        for (ICraftingPreviewElement stack : message.stacks) {
            buf.func_192572_a(stack.getId());
            stack.write(buf);
        }
    }

    public static void handle(GridCraftingPreviewResponseMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientProxy.onReceivedCraftingPreviewResponseMessage(message));
        ctx.get().setPacketHandled(true);
    }
}

