/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container;

import com.raoulvdberge.refinedstorage.RSContainers;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.CrafterManagerNetworkNode;
import com.raoulvdberge.refinedstorage.container.BaseContainer;
import com.raoulvdberge.refinedstorage.container.slot.CrafterManagerSlot;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.item.validator.PatternItemValidator;
import com.raoulvdberge.refinedstorage.item.PatternItem;
import com.raoulvdberge.refinedstorage.screen.IScreenInfoProvider;
import com.raoulvdberge.refinedstorage.screen.grid.filtering.GridFilterParser;
import com.raoulvdberge.refinedstorage.screen.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.stack.ItemGridStack;
import com.raoulvdberge.refinedstorage.tile.CrafterManagerTile;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CrafterManagerContainer
extends BaseContainer {
    private IScreenInfoProvider screenInfoProvider;
    private CrafterManagerNetworkNode crafterManager;
    private Map<String, Integer> containerData;
    private Map<String, IItemHandlerModifiable> dummyInventories = new HashMap<String, IItemHandlerModifiable>();
    private Map<String, Integer> headings = new HashMap<String, Integer>();
    private int rows;

    public CrafterManagerContainer(CrafterManagerTile crafterManager, PlayerEntity player, int windowId) {
        super(RSContainers.CRAFTER_MANAGER, crafterManager, player, windowId);
        this.crafterManager = (CrafterManagerNetworkNode)crafterManager.getNode();
    }

    public void setScreenInfoProvider(IScreenInfoProvider infoProvider) {
        this.screenInfoProvider = infoProvider;
    }

    public void initSlotsServer() {
        this.addPlayerInventory(8, this.screenInfoProvider.getYPlayerInventory());
        if (this.crafterManager.getNetwork() != null) {
            for (Map.Entry<ITextComponent, List<IItemHandlerModifiable>> entry : this.crafterManager.getNetwork().getCraftingManager().getNamedContainers().entrySet()) {
                for (IItemHandlerModifiable handler : entry.getValue()) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        this.func_75146_a((Slot)new CrafterManagerSlot((IItemHandler)handler, i, 0, 0, true, this.screenInfoProvider, this.crafterManager));
                    }
                }
            }
        }
    }

    public void initSlots(@Nullable Map<String, Integer> data) {
        if (data != null) {
            this.containerData = data;
        }
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.headings.clear();
        this.rows = 0;
        this.addPlayerInventory(8, this.screenInfoProvider.getYPlayerInventory());
        int y = 37 - this.screenInfoProvider.getCurrentOffset() * 18;
        int x = 8;
        List<Predicate<IGridStack>> filters = GridFilterParser.getFilters(null, this.screenInfoProvider.getSearchFieldText(), Collections.emptyList());
        for (Map.Entry<String, Integer> category : this.containerData.entrySet()) {
            Object dummy;
            if (data == null) {
                dummy = this.dummyInventories.get(category.getKey());
            } else {
                dummy = new BaseItemHandler(category.getValue()){

                    public int getSlotLimit(int slot) {
                        return 1;
                    }

                    @Override
                    @Nonnull
                    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                        if (new PatternItemValidator(CrafterManagerContainer.this.getPlayer().func_130014_f_()).test(stack)) {
                            return super.insertItem(slot, stack, simulate);
                        }
                        return stack;
                    }
                };
                this.dummyInventories.put(category.getKey(), (IItemHandlerModifiable)dummy);
            }
            boolean foundItemsInCategory = false;
            int yHeading = y - 19;
            int slotFound = 0;
            for (int slot = 0; slot < category.getValue(); ++slot) {
                boolean visible = true;
                if (!this.screenInfoProvider.getSearchFieldText().trim().isEmpty()) {
                    ItemStack stack = dummy.getStackInSlot(slot);
                    if (stack.func_190926_b()) {
                        visible = false;
                    } else {
                        CraftingPattern pattern = PatternItem.fromCache(this.crafterManager.getWorld(), stack);
                        visible = false;
                        block2: for (ItemStack output : pattern.getOutputs()) {
                            ItemGridStack outputConverted = new ItemGridStack(output);
                            for (Predicate<IGridStack> filter : filters) {
                                if (!filter.test(outputConverted)) continue;
                                visible = true;
                                continue block2;
                            }
                        }
                    }
                }
                this.func_75146_a((Slot)new CrafterManagerSlot((IItemHandler)dummy, slot, x, y, visible, this.screenInfoProvider, this.crafterManager));
                if (!visible) continue;
                foundItemsInCategory = true;
                x += 18;
                if ((slotFound + 1) % 9 == 0 && slot + 1 < category.getValue()) {
                    x = 8;
                    y += 18;
                    ++this.rows;
                }
                ++slotFound;
            }
            if (!foundItemsInCategory) continue;
            this.headings.put(category.getKey(), yHeading);
            x = 8;
            y += 36;
            this.rows += 2;
        }
    }

    public Map<String, Integer> getHeadings() {
        return this.headings;
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(index);
        if (slot.func_75216_d()) {
            stack = slot.func_75211_c();
            if (index < 36 ? !this.func_75135_a(stack, 36, this.field_75151_b.size(), false) : !this.func_75135_a(stack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }
}

