/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeFactory;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkNodeManager
extends WorldSavedData
implements INetworkNodeManager {
    public static final String NAME = "refinedstorage_nodes";
    private static final String NBT_NODES = "Nodes";
    private static final String NBT_NODE_ID = "Id";
    private static final String NBT_NODE_DATA = "Data";
    private static final String NBT_NODE_POS = "Pos";
    private final World world;
    private Logger logger = LogManager.getLogger(this.getClass());
    private ConcurrentHashMap<BlockPos, INetworkNode> nodes = new ConcurrentHashMap();

    public NetworkNodeManager(String name, World world) {
        super(name);
        this.world = world;
    }

    public void func_76184_a(CompoundNBT tag) {
        if (tag.func_74764_b(NBT_NODES)) {
            ListNBT nodesTag = tag.func_150295_c(NBT_NODES, 10);
            this.nodes.clear();
            for (int i = 0; i < nodesTag.size(); ++i) {
                CompoundNBT nodeTag = nodesTag.func_150305_b(i);
                ResourceLocation id = new ResourceLocation(nodeTag.func_74779_i(NBT_NODE_ID));
                CompoundNBT data = nodeTag.func_74775_l(NBT_NODE_DATA);
                BlockPos pos = BlockPos.func_218283_e((long)nodeTag.func_74763_f(NBT_NODE_POS));
                INetworkNodeFactory factory = API.instance().getNetworkNodeRegistry().get(id);
                if (factory != null) {
                    INetworkNode node = null;
                    try {
                        node = factory.create(data, this.world, pos);
                    }
                    catch (Throwable t) {
                        this.logger.error("Could not read network node", t);
                    }
                    if (node == null) continue;
                    this.nodes.put(pos, node);
                    continue;
                }
                this.logger.warn("Factory for " + id + " not found in network node registry");
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        for (INetworkNode node : this.all()) {
            try {
                CompoundNBT nodeTag = new CompoundNBT();
                nodeTag.func_74778_a(NBT_NODE_ID, node.getId().toString());
                nodeTag.func_74772_a(NBT_NODE_POS, node.getPos().func_218275_a());
                nodeTag.func_218657_a(NBT_NODE_DATA, (INBT)node.write(new CompoundNBT()));
                list.add((Object)nodeTag);
            }
            catch (Throwable t) {
                this.logger.error("Error while saving network node", t);
            }
        }
        tag.func_218657_a(NBT_NODES, (INBT)list);
        return tag;
    }

    @Override
    @Nullable
    public INetworkNode getNode(BlockPos pos) {
        return this.nodes.get(pos);
    }

    @Override
    public void removeNode(BlockPos pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        this.nodes.remove(pos);
    }

    @Override
    public void setNode(BlockPos pos, INetworkNode node) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        this.nodes.put(pos, node);
    }

    @Override
    public Collection<INetworkNode> all() {
        return this.nodes.values();
    }

    @Override
    public void markForSaving() {
        this.func_76185_a();
    }
}

