/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6;

import com.google.common.primitives.Ints;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6.Crafting;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6.CraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6.Processing;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.apache.logging.log4j.LogManager;

public abstract class Craft {
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_ROOT = "Root";
    private static final String NBT_IS_PROCESSING = "IsProcessing";
    private static final String NBT_ITEMS_TO_USE = "ItemsToUse";
    private static final String NBT_QUANTITY = "Quantity";
    private static final String NBT_NEEDED_PER_CRAFT = "NeededPerCraft";
    private boolean root;
    protected int quantity;
    private ICraftingPattern pattern;
    private Map<Integer, IStackList<ItemStack>> itemsToUse = new LinkedHashMap<Integer, IStackList<ItemStack>>();
    private Map<Integer, Integer> neededPerCraft = new LinkedHashMap<Integer, Integer>();

    Craft(ICraftingPattern pattern, boolean root) {
        this.pattern = pattern;
        this.root = root;
    }

    Craft(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        this.quantity = tag.func_74762_e(NBT_QUANTITY);
        this.pattern = CraftingTask.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.getWorld());
        this.root = tag.func_74767_n(NBT_ROOT);
        ListNBT list = tag.func_150295_c(NBT_ITEMS_TO_USE, 9);
        for (int i = 0; i < list.size(); ++i) {
            this.itemsToUse.put(i, CraftingTask.readItemStackList(list.func_202169_e(i)));
        }
        List perCraftList = Ints.asList((int[])tag.func_74759_k(NBT_NEEDED_PER_CRAFT));
        for (int i = 0; i < perCraftList.size(); ++i) {
            this.neededPerCraft.put(i, (Integer)perCraftList.get(i));
        }
    }

    static Craft createCraftFromNBT(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        return tag.func_74767_n(NBT_IS_PROCESSING) ? new Processing(network, tag) : new Crafting(network, tag);
    }

    ICraftingPattern getPattern() {
        return this.pattern;
    }

    int getQuantity() {
        return this.quantity;
    }

    void addQuantity(int quantity) {
        this.quantity += quantity;
    }

    void next() {
        --this.quantity;
    }

    boolean isRoot() {
        return this.root;
    }

    boolean hasItems() {
        return !this.itemsToUse.isEmpty();
    }

    IStackList<ItemStack> getItemsToUse(boolean simulate) {
        IStackList<ItemStack> toReturn = API.instance().createItemStackList();
        for (int i = 0; i < this.itemsToUse.size(); ++i) {
            int needed = this.neededPerCraft.get(i);
            if (!this.itemsToUse.get(i).isEmpty()) {
                Iterator<StackListEntry<ItemStack>> it = this.itemsToUse.get(i).getStacks().iterator();
                while (needed > 0 && it.hasNext()) {
                    ItemStack toUse = it.next().getStack();
                    if (needed < toUse.func_190916_E()) {
                        if (!simulate) {
                            this.itemsToUse.get(i).remove(toUse, needed);
                        }
                        toReturn.add(toUse, needed);
                        needed = 0;
                        continue;
                    }
                    if (!simulate) {
                        it.remove();
                    }
                    needed -= toUse.func_190916_E();
                    toReturn.add(toUse);
                }
                continue;
            }
            LogManager.getLogger(Craft.class).warn("Craft requested more Items than available");
            this.quantity = 0;
            break;
        }
        return toReturn;
    }

    void addItemsToUse(int ingredientNumber, ItemStack stack, int size, int perCraft) {
        if (!this.neededPerCraft.containsKey(ingredientNumber)) {
            this.neededPerCraft.put(ingredientNumber, perCraft);
        }
        if (!this.itemsToUse.containsKey(ingredientNumber)) {
            this.itemsToUse.put(ingredientNumber, API.instance().createItemStackList());
        }
        this.itemsToUse.get(ingredientNumber).add(stack, size);
    }

    CompoundNBT writeToNbt() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(NBT_QUANTITY, this.quantity);
        tag.func_74757_a(NBT_IS_PROCESSING, this instanceof Processing);
        tag.func_74757_a(NBT_ROOT, this.root);
        tag.func_218657_a(NBT_PATTERN, (INBT)CraftingTask.writePatternToNbt(this.pattern));
        ListNBT list = new ListNBT();
        for (IStackList<ItemStack> stackList : this.itemsToUse.values()) {
            list.add((Object)CraftingTask.writeItemStackList(stackList));
        }
        tag.func_218657_a(NBT_ITEMS_TO_USE, (INBT)list);
        tag.func_74783_a(NBT_NEEDED_PER_CRAFT, Ints.toArray(this.neededPerCraft.values()));
        return tag;
    }
}

