/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v5;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v5.CraftingTask;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

class Crafting {
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_TOOK = "Took";
    private static final String NBT_TO_EXTRACT = "ToExtract";
    private static final String NBT_ROOT = "Root";
    private ICraftingPattern pattern;
    private NonNullList<ItemStack> took;
    private IStackList<ItemStack> toExtract;
    private boolean root;

    public Crafting(ICraftingPattern pattern, NonNullList<ItemStack> took, IStackList<ItemStack> toExtract, boolean root) {
        this.pattern = pattern;
        this.took = took;
        this.toExtract = toExtract;
        this.root = root;
    }

    public Crafting(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        this.pattern = CraftingTask.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.getWorld());
        this.toExtract = CraftingTask.readItemStackList(tag.func_150295_c(NBT_TO_EXTRACT, 10));
        this.root = tag.func_74767_n(NBT_ROOT);
        this.took = NonNullList.func_191196_a();
        ListNBT tookList = tag.func_150295_c(NBT_TOOK, 10);
        for (int i = 0; i < tookList.size(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(tookList.func_150305_b(i));
            this.took.add((Object)stack);
        }
    }

    public boolean isRoot() {
        return this.root;
    }

    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    public NonNullList<ItemStack> getTook() {
        return this.took;
    }

    public IStackList<ItemStack> getToExtract() {
        return this.toExtract;
    }

    public CompoundNBT writeToNbt() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBT_PATTERN, (INBT)CraftingTask.writePatternToNbt(this.pattern));
        tag.func_218657_a(NBT_TO_EXTRACT, (INBT)CraftingTask.writeItemStackList(this.toExtract));
        tag.func_74757_a(NBT_ROOT, this.root);
        ListNBT tookList = new ListNBT();
        for (ItemStack took : this.took) {
            tookList.add((Object)StackUtils.serializeStackToNbt(took));
        }
        tag.func_218657_a(NBT_TOOK, (INBT)tookList);
        return tag;
    }
}

