/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.util.TagBuilder;
import shadows.placebo.util.PlaceboUtil;

public class ArmorSet {
    private static final Multimap<Integer, ArmorSet> LEVEL_TO_SETS = HashMultimap.create();
    private static final Map<ResourceLocation, ArmorSet> REGISTRY = new HashMap<ResourceLocation, ArmorSet>();
    private static int maxLevel = 0;
    final int level;
    final ResourceLocation name;
    ItemStack mainhand;
    ItemStack offhand;
    ItemStack feet;
    ItemStack legs;
    ItemStack chest;
    ItemStack head;
    EnumMap<EquipmentSlotType, ItemStack> slotMap = new EnumMap(EquipmentSlotType.class);
    List<WeightedRandomStack> possibleMainhands = new ArrayList<WeightedRandomStack>();

    public ArmorSet(ResourceLocation name, int level, ItemStack ... set) {
        this.level = level;
        this.mainhand = set[0];
        this.offhand = set[1];
        this.feet = set[2];
        this.legs = set[3];
        this.chest = set[4];
        this.head = set[5];
        for (int i = 0; i < 6; ++i) {
            this.slotMap.put(EquipmentSlotType.values()[i], set[i]);
        }
        this.name = name;
    }

    public ArmorSet(ResourceLocation name, int level, Object ... set) {
        this(name, level, PlaceboUtil.toStackArray((Object[])set));
    }

    public LivingEntity apply(LivingEntity entity) {
        for (EquipmentSlotType e : EquipmentSlotType.values()) {
            entity.func_184201_a(e, this.slotMap.get(e).func_77946_l());
        }
        if (!this.possibleMainhands.isEmpty()) {
            entity.func_184611_a(Hand.MAIN_HAND, ((WeightedRandomStack)WeightedRandom.func_76271_a((Random)ThreadLocalRandom.current(), this.possibleMainhands)).getStack().func_77946_l());
        }
        return entity;
    }

    public CompoundNBT apply(CompoundNBT entity) {
        ItemStack main = this.mainhand;
        if (!this.possibleMainhands.isEmpty()) {
            main = ((WeightedRandomStack)WeightedRandom.func_76271_a((Random)ThreadLocalRandom.current(), this.possibleMainhands)).getStack();
        }
        return TagBuilder.setEquipment(entity, main, this.offhand, this.feet, this.legs, this.chest, this.head);
    }

    public ArmorSet addExtraMains(ItemStack ... tools) {
        this.setupList();
        for (ItemStack s : tools) {
            this.possibleMainhands.add(new WeightedRandomStack(s, 1));
        }
        return this;
    }

    public ArmorSet addExtraMains(Object ... tools) {
        return this.addExtraMains(PlaceboUtil.toStackArray((Object[])tools));
    }

    public List<WeightedRandomStack> getPossibleMainhands() {
        return this.possibleMainhands;
    }

    public void setupList() {
        if (this.possibleMainhands.isEmpty()) {
            this.possibleMainhands.add(new WeightedRandomStack(this.mainhand, 3));
        }
    }

    public static void register(ArmorSet set) {
        if (!REGISTRY.containsKey(set.name)) {
            REGISTRY.put(set.name, set);
            LEVEL_TO_SETS.put((Object)set.level, (Object)set);
            if (set.level > maxLevel) {
                maxLevel = set.level;
            }
        } else {
            DeadlyModule.LOGGER.error("Attempted to register an ArmorSet with name {}, but it already exists!", (Object)set.name);
        }
    }

    @Nullable
    public static ArmorSet getByName(ResourceLocation name) {
        return REGISTRY.get(name);
    }

    public static void unregister(ResourceLocation name) {
        ArmorSet set = REGISTRY.remove(name);
        if (set != null) {
            LEVEL_TO_SETS.remove((Object)set.level, (Object)set);
            if (!LEVEL_TO_SETS.containsKey((Object)maxLevel)) {
                for (int i = maxLevel; i >= 0; --i) {
                    if (!LEVEL_TO_SETS.containsKey((Object)i) && i != 0) continue;
                    maxLevel = i;
                    break;
                }
            }
        }
    }

    public static int getMaxLevel() {
        return maxLevel;
    }

    public static ArmorSet getSetFor(int level, Random random) {
        Collection sets = null;
        while (sets == null || sets.isEmpty()) {
            sets = LEVEL_TO_SETS.get((Object)level--);
        }
        return (ArmorSet)sets.stream().skip(random.nextInt(sets.size())).findFirst().get();
    }

    public static class WeightedRandomStack
    extends WeightedRandom.Item {
        final ItemStack stack;

        public WeightedRandomStack(ItemStack stack, int weight) {
            super(weight);
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

