/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.compat;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import shadows.apotheosis.spawn.SpawnerModifiers;
import shadows.apotheosis.spawn.TileSpawnerExt;
import shadows.apotheosis.spawn.modifiers.EggModifier;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.placebo.util.PlaceboUtil;

public class SpawnerWrapper {
    public static final List<ItemStack> SPAWNER = Collections.singletonList(new ItemStack((IItemProvider)Blocks.field_150474_ac));
    SpawnerModifier modifier;
    ItemStack output;
    String[] tooltips;

    public SpawnerWrapper(SpawnerModifier modifier, String nbt, String ... tooltips) {
        this.modifier = modifier;
        this.output = SPAWNER.get(0).func_77946_l();
        CompoundNBT tag = this.output.func_190925_c("BlockEntityTag");
        tag.func_74768_a(nbt, tag.func_74762_e(nbt) + modifier.getValue());
        this.tooltips = tooltips;
    }

    public SpawnerWrapper(SpawnerModifier modifier, String nbt, boolean change, String ... tooltips) {
        this.modifier = modifier;
        this.output = SPAWNER.get(0).func_77946_l();
        CompoundNBT tag = this.output.func_190925_c("BlockEntityTag");
        tag.func_74757_a(nbt, change);
        this.tooltips = tooltips;
    }

    public SpawnerWrapper(ItemStack catalyst, ResourceLocation entityOut, String ... tooltips) {
        this.modifier = new EggModifier(catalyst);
        this.output = SPAWNER.get(0).func_77946_l();
        CompoundNBT tag = this.output.func_190925_c("BlockEntityTag");
        tag.func_74775_l("SpawnData").func_74778_a("id", entityOut.toString());
        this.tooltips = tooltips;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(SPAWNER, PlaceboUtil.asList((Object[])this.modifier.getIngredient().func_193365_a())));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void drawInfo(Minecraft mc, int width, int height, double mouseX, double mouseY) {
        for (int i = 0; i < this.tooltips.length; ++i) {
            FontRenderer fontRenderer = mc.field_71466_p;
            String string = I18n.func_135052_a((String)this.tooltips[i], (Object[])new Object[0]);
            mc.field_71466_p.getClass();
            fontRenderer.func_211126_b(string, 0.0f, (float)(height - 9 * (2 - i)), 0);
        }
    }

    static {
        new TileSpawnerExt().func_189515_b(SPAWNER.get(0).func_190925_c("BlockEntityTag"));
    }

    public static class SpawnerInverseWrapper
    extends SpawnerWrapper {
        public SpawnerInverseWrapper() {
            super(null, "", false, "jei.spw.invert", "jei.spw.invert2");
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(Collections.emptyList(), PlaceboUtil.asList((Object[])SpawnerModifiers.inverseItem.func_193365_a())));
        }
    }
}

