/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import shadows.apotheosis.deadly.DeadlyLoot;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.config.DeadlyConstants;
import shadows.apotheosis.deadly.gen.SpawnerItem;
import shadows.apotheosis.deadly.gen.WorldFeature;
import shadows.apotheosis.deadly.gen.WorldGenerator;
import shadows.placebo.util.ChestBuilder;

public class SwarmSpawner
extends WorldFeature {
    public static final ArrayList<SpawnerItem> SWARM_SPAWNERS = new ArrayList();

    @Override
    public boolean generate(IWorld world, int chunkX, int chunkZ, Random rand) {
        int y;
        if ((double)DeadlyConfig.swarmSpawnerChance <= rand.nextDouble()) {
            return false;
        }
        int x = (chunkX << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        int z = (chunkZ << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        BlockPos.Mutable mPos = new BlockPos.Mutable(x, y, z);
        for (y = 15 + rand.nextInt(35); y > 10; --y) {
            if (!this.canBePlaced(world, (BlockPos)mPos.func_181079_c(x, y, z), rand)) continue;
            this.place(world, (BlockPos)mPos.func_181079_c(x, y, z), rand);
            WorldGenerator.setSuccess(world.func_201675_m().func_186058_p().getRegistryName(), chunkX, chunkZ);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBePlaced(IWorld world, BlockPos pos, Random rand) {
        BlockState state = world.func_180495_p(pos);
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        BlockState upState = world.func_180495_p(pos.func_177984_a());
        return WorldGenerator.STONE_TEST.test(downState) && upState.isAir((IBlockReader)world, pos.func_177984_a()) && (state.isAir((IBlockReader)world, pos) || WorldGenerator.STONE_TEST.test(state));
    }

    @Override
    public void place(IWorld world, BlockPos pos, Random rand) {
        ChestBuilder.place((IWorld)world, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(rand.nextInt(12) == 0 ? DeadlyLoot.CHEST_VALUABLE : DeadlyLoot.SPAWNER_SWARM));
        ((SpawnerItem)WeightedRandom.func_76271_a((Random)rand, SWARM_SPAWNERS)).place(world, pos);
        world.func_180501_a(pos.func_177984_a(), Blocks.field_196580_bH.func_176223_P(), 2);
        WorldGenerator.debugLog(pos, "Swarm Spawner");
    }

    @Override
    public boolean isEnabled() {
        return !SWARM_SPAWNERS.isEmpty() && DeadlyConfig.swarmSpawnerChance > 0.0f;
    }

    public static void init() {
        SpawnerItem.addItems(SWARM_SPAWNERS, DeadlyConstants.SWARM_SPAWNER_STATS, DeadlyConfig.SWARM_MOBS);
    }
}

