/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APReferences;
import cofh.lib.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class SlimeArrowEntity
extends AbstractArrowEntity {
    private static float MAX_VELOCITY = 3.0f;
    private static float MIN_VELOCITY = 0.5f;
    public static float baseDamage = 0.5f;
    public static int baseBounces = 4;
    public static int baseKnockback = 4;
    public static boolean knockbackBoost = true;
    private int curBounces = 0;
    private int maxBounces = baseBounces;

    public SlimeArrowEntity(EntityType<? extends SlimeArrowEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.field_70255_ao = baseDamage;
        this.func_70240_a(0);
    }

    public SlimeArrowEntity(World worldIn, LivingEntity shooter) {
        super(APReferences.SLIME_ARROW_ENTITY, shooter, worldIn);
        this.field_70255_ao = baseDamage;
        this.func_70240_a(0);
    }

    public SlimeArrowEntity(World worldIn, double x, double y, double z) {
        super(APReferences.SLIME_ARROW_ENTITY, x, y, z, worldIn);
        this.field_70255_ao = baseDamage;
        this.func_70240_a(0);
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)APReferences.SLIME_ARROW_ITEM);
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        if (raytraceResultIn.func_216346_c() != RayTraceResult.Type.MISS) {
            this.func_213869_a(SoundEvents.field_187878_fo);
            if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.func_213868_a((EntityRayTraceResult)raytraceResultIn);
            } else if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.BLOCK) {
                Vec3d motion = this.func_213322_ci();
                if (motion.func_189985_c() < (double)MIN_VELOCITY || this.func_70090_H() || this.curBounces >= this.maxBounces) {
                    super.func_184549_a(raytraceResultIn);
                    return;
                }
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceResultIn;
                switch (blockraytraceresult.func_216354_b()) {
                    case DOWN: 
                    case UP: {
                        this.func_213293_j(motion.field_72450_a, motion.field_72448_b * -1.0, motion.field_72449_c);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        this.func_213293_j(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c * -1.0);
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        this.func_213293_j(motion.field_72450_a * -1.0, motion.field_72448_b, motion.field_72449_c);
                    }
                }
                float f = MathHelper.func_76133_a((double)SlimeArrowEntity.func_213296_b((Vec3d)motion));
                this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.2957763671875);
                this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f) * 57.2957763671875);
                this.field_70126_B = this.field_70177_z;
                this.field_70127_C = this.field_70125_A;
                ++this.curBounces;
                --this.field_70256_ap;
            }
        }
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70243_d(boolean critical) {
    }

    public void func_70240_a(int knockbackStrengthIn) {
        super.func_70240_a(baseKnockback + knockbackStrengthIn);
        if (knockbackBoost) {
            this.maxBounces = baseBounces + this.field_70256_ap;
        }
    }

    public void func_213872_b(byte level) {
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        super.func_70186_c(x, y, z, Math.min(velocity, MAX_VELOCITY), inaccuracy);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if ((!this.field_70254_i || this.func_203047_q()) && Utils.isClientWorld((World)this.field_70170_p)) {
            Vec3d vec3d = this.func_213322_ci();
            double d1 = vec3d.field_72450_a;
            double d2 = vec3d.field_72448_b;
            double d0 = vec3d.field_72449_c;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197592_C, this.func_226277_ct_() + d1 * 0.25, this.func_226278_cu_() + d2 * 0.25, this.func_226281_cx_() + d0 * 0.25, -d1, -d2 + 0.2, -d0);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ArrowData", this.curBounces);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.curBounces = compound.func_74762_e("ArrowData");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

