/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APReferences;
import cofh.lib.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ShulkerArrowEntity
extends AbstractArrowEntity {
    private static final DataParameter<Integer> TARGET = EntityDataManager.func_187226_a(ShulkerArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int ID_NO_TARGET = -1;
    private static final float MAX_VELOCITY = 3.0f;
    private static final double SEEK_DISTANCE = 5.0;
    private static final double SEEK_FACTOR = 0.2;
    private static final double SEEK_ANGLE = 0.5235987755982988;
    private static final double SEEK_THRESHOLD = 0.5;
    public static int effectDuration = 100;

    public ShulkerArrowEntity(EntityType<? extends ShulkerArrowEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    public ShulkerArrowEntity(World worldIn, LivingEntity shooter) {
        super(APReferences.SHULKER_ARROW_ENTITY, shooter, worldIn);
    }

    public ShulkerArrowEntity(World worldIn, double x, double y, double z) {
        super(APReferences.SHULKER_ARROW_ENTITY, x, y, z, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TARGET, (Object)-1);
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)APReferences.SHULKER_ARROW_ITEM);
    }

    protected void func_213868_a(EntityRayTraceResult raytraceResultIn) {
        super.func_213868_a(raytraceResultIn);
        Entity entity = raytraceResultIn.func_216348_a();
        if (!entity.func_190530_aW() && entity instanceof LivingEntity && effectDuration > 0) {
            LivingEntity living = (LivingEntity)entity;
            living.func_195064_c(new EffectInstance(Effects.field_188424_y, effectDuration));
        }
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70071_h_() {
        if (!this.field_70254_i) {
            Entity target;
            if (Utils.isServerWorld((World)this.field_70170_p)) {
                this.updateTarget();
            }
            if ((target = this.getTarget()) != null) {
                Vec3d targetVec = this.getVectorToTarget(target).func_186678_a(0.2);
                Vec3d courseVec = this.func_213322_ci();
                double courseLen = courseVec.func_72433_c();
                double targetLen = targetVec.func_72433_c();
                double totalLen = Math.sqrt(courseLen * courseLen + targetLen * targetLen);
                double dotProduct = courseVec.func_72430_b(targetVec) / (courseLen * targetLen);
                if (dotProduct > 0.5) {
                    Vec3d newMotion = courseVec.func_186678_a(courseLen / totalLen).func_178787_e(targetVec.func_186678_a(targetLen / totalLen)).func_72432_b().func_186678_a(3.0);
                    this.func_213293_j(newMotion.field_72450_a, newMotion.field_72448_b + (double)0.05f, newMotion.field_72449_c);
                } else if (Utils.isServerWorld((World)this.field_70170_p)) {
                    this.setTarget(null);
                }
                if (Utils.isClientWorld((World)this.field_70170_p)) {
                    Vec3d vec3d = this.func_213322_ci().func_186678_a(0.25);
                    double d1 = vec3d.field_72450_a;
                    double d2 = vec3d.field_72448_b;
                    double d0 = vec3d.field_72449_c;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, this.func_226277_ct_() + d1, this.func_226278_cu_() + d2, this.func_226281_cx_() + d0, -d1, -d2 + 0.2, -d0);
                }
            }
        }
        super.func_70071_h_();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void updateTarget() {
        if (this.func_70090_H() || this.func_180799_ab()) {
            this.setTarget(null);
            return;
        }
        Entity target = this.getTarget();
        if (target != null && !target.func_70089_S()) {
            target = null;
            this.setTarget(null);
        }
        if (target == null) {
            AxisAlignedBB positionBB;
            AxisAlignedBB targetBB = positionBB = new AxisAlignedBB(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            Vec3d courseVec = this.func_213322_ci().func_186678_a(5.0).func_178785_b(0.5235988f);
            targetBB = targetBB.func_111270_a(positionBB.func_191194_a(courseVec));
            courseVec = this.func_213322_ci().func_186678_a(5.0).func_178785_b(-0.5235988f);
            targetBB = targetBB.func_111270_a(positionBB.func_191194_a(courseVec));
            targetBB = targetBB.func_72314_b(0.0, 2.5, 0.0);
            double closestDot = -1.0;
            LivingEntity closestTarget = null;
            for (LivingEntity living : this.field_70170_p.func_217357_a(LivingEntity.class, targetBB)) {
                Vec3d targetVec;
                Vec3d motionVec;
                double dot;
                if (living instanceof PlayerEntity || !((dot = (motionVec = this.func_213322_ci().func_72432_b()).func_72430_b(targetVec = this.getVectorToTarget((Entity)living).func_72432_b())) > Math.max(closestDot, 0.5))) continue;
                closestDot = dot;
                closestTarget = living;
            }
            if (closestTarget != null) {
                this.setTarget((Entity)closestTarget);
            }
        }
    }

    private Vec3d getVectorToTarget(Entity target) {
        return new Vec3d(target.func_226277_ct_() - this.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e() - this.func_226278_cu_(), target.func_226281_cx_() - this.func_226281_cx_());
    }

    @Nullable
    private Entity getTarget() {
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET)).intValue());
    }

    private void setTarget(@Nullable Entity e) {
        this.field_70180_af.func_187227_b(TARGET, (Object)(e == null ? -1 : e.func_145782_y()));
    }
}

