/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.FluidModule1;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CompiledFluidModule1
extends CompiledModule {
    public static final String NBT_FORCE_EMPTY = "ForceEmpty";
    public static final String NBT_MAX_TRANSFER = "MaxTransfer";
    public static final String NBT_FLUID_DIRECTION = "FluidDir";
    private final int maxTransfer;
    private final FluidModule1.FluidDirection fluidDirection;
    private final boolean forceEmpty;

    public CompiledFluidModule1(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        CompoundNBT compound = this.setupNBT(stack);
        this.maxTransfer = compound.func_74762_e(NBT_MAX_TRANSFER);
        this.fluidDirection = FluidModule1.FluidDirection.values()[compound.func_74771_c(NBT_FLUID_DIRECTION)];
        this.forceEmpty = compound.func_74767_n(NBT_FORCE_EMPTY);
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        LazyOptional routerCap = router.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (!routerCap.isPresent()) {
            return false;
        }
        World world = router.func_145831_w();
        BlockPos pos = this.getTarget().gPos.func_218180_b();
        LazyOptional worldFluidCap = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)this.getFacing().func_176734_d());
        boolean didWork = false;
        if (!worldFluidCap.isPresent()) {
            boolean playSound = router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) == 0;
            switch (this.fluidDirection) {
                case IN: {
                    didWork = this.tryPickupFluid((LazyOptional<IFluidHandlerItem>)routerCap, world, pos, playSound);
                    break;
                }
                case OUT: {
                    didWork = this.tryPourOutFluid((LazyOptional<IFluidHandlerItem>)routerCap, world, pos, playSound);
                }
            }
        } else {
            switch (this.fluidDirection) {
                case IN: {
                    didWork = (Boolean)worldFluidCap.map(srcHandler -> (Boolean)routerCap.map(dstHandler -> this.doTransfer(router, (IFluidHandler)srcHandler, (IFluidHandler)dstHandler, FluidModule1.FluidDirection.IN)).orElse((Object)false)).orElse((Object)false);
                    break;
                }
                case OUT: {
                    didWork = (Boolean)routerCap.map(srcHandler -> (Boolean)worldFluidCap.map(dstHandler -> this.doTransfer(router, (IFluidHandler)srcHandler, (IFluidHandler)dstHandler, FluidModule1.FluidDirection.OUT)).orElse((Object)false)).orElse((Object)false);
                }
            }
        }
        if (didWork) {
            routerCap.ifPresent(h -> router.setBufferItemStack(h.getContainer()));
        }
        return didWork;
    }

    private boolean tryPickupFluid(LazyOptional<IFluidHandlerItem> routerCap, World world, BlockPos pos, boolean playSound) {
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof IBucketPickupHandler)) {
            return false;
        }
        IFluidState fluidState = state.func_204520_s();
        Fluid fluid = fluidState.func_206886_c();
        if (fluid == Fluids.field_204541_a || !fluid.func_207193_c(fluidState) || !this.getFilter().testFluid(fluid)) {
            return false;
        }
        FluidTank tank = new FluidTank(1000);
        tank.setFluid(new FluidStack(fluid, 1000));
        FluidStack maybeSent = (FluidStack)routerCap.map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)tank, (int)1000, (boolean)false)).orElse((Object)FluidStack.EMPTY);
        if (maybeSent.getAmount() != 1000) {
            return false;
        }
        ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, pos, state);
        FluidStack transferred = (FluidStack)routerCap.map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)tank, (int)1000, (boolean)true)).orElse((Object)FluidStack.EMPTY);
        if (!transferred.isEmpty() && playSound) {
            this.playFillSound(world, pos, fluid);
        }
        return !transferred.isEmpty();
    }

    private boolean tryPourOutFluid(LazyOptional<IFluidHandlerItem> routerFluidCap, World world, BlockPos pos, boolean playSound) {
        boolean isReplaceable;
        BlockState blockstate;
        if (!(this.forceEmpty || world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() instanceof ILiquidContainer)) {
            return false;
        }
        Material material = (blockstate = world.func_180495_p(pos)).func_185904_a();
        boolean isNotSolid = !material.func_76220_a();
        boolean didWork = (Boolean)routerFluidCap.map(arg_0 -> this.lambda$tryPourOutFluid$7(blockstate, world, pos, isNotSolid, isReplaceable = material.func_76222_j(), playSound, arg_0)).orElse((Object)false);
        if (didWork) {
            routerFluidCap.ifPresent(handler -> handler.drain(1000, IFluidHandler.FluidAction.EXECUTE));
        }
        return didWork;
    }

    private void playEmptySound(World world, BlockPos pos, Fluid fluid) {
        SoundEvent soundevent = fluid.getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        world.func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private void playFillSound(World world, BlockPos pos, Fluid fluid) {
        SoundEvent soundEvent = fluid.getAttributes().getFillSound();
        if (soundEvent == null) {
            soundEvent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
        }
        world.func_184133_a(null, pos, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private void playEvaporationEffects(World world, BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    private boolean isInfiniteWaterSource(World world, BlockPos pos) {
        return false;
    }

    private boolean doTransfer(TileEntityItemRouter router, IFluidHandler src, IFluidHandler dest, FluidModule1.FluidDirection direction) {
        int amount;
        FluidStack newStack;
        if (this.getRegulationAmount() > 0) {
            if (direction == FluidModule1.FluidDirection.IN && this.checkFluidPercent(src) <= this.getRegulationAmount()) {
                return false;
            }
            if (direction == FluidModule1.FluidDirection.OUT && this.checkFluidPercent(dest) >= this.getRegulationAmount()) {
                return false;
            }
        }
        if (!(newStack = FluidUtil.tryFluidTransfer((IFluidHandler)dest, (IFluidHandler)src, (int)(amount = Math.min(this.maxTransfer, router.getCurrentFluidTransferAllowance(direction))), (boolean)false)).isEmpty() && this.getFilter().testFluid(newStack.getFluid()) && !(newStack = FluidUtil.tryFluidTransfer((IFluidHandler)dest, (IFluidHandler)src, (int)newStack.getAmount(), (boolean)true)).isEmpty()) {
            router.transferredFluid(newStack.getAmount(), direction);
            return true;
        }
        return false;
    }

    private int checkFluidPercent(IFluidHandler handler) {
        int total = 0;
        int max = 0;
        for (int idx = 0; idx < handler.getTanks(); ++idx) {
            max += handler.getTankCapacity(idx);
            total += handler.getFluidInTank(idx).getAmount();
        }
        return total * 100 / max;
    }

    private CompoundNBT setupNBT(ItemStack stack) {
        CompoundNBT compound = ModuleHelper.validateNBT(stack);
        if (!compound.func_74764_b(NBT_MAX_TRANSFER)) {
            compound.func_74768_a(NBT_MAX_TRANSFER, 1000);
        }
        if (!compound.func_74764_b(NBT_FLUID_DIRECTION)) {
            compound.func_74774_a(NBT_FLUID_DIRECTION, (byte)FluidModule1.FluidDirection.IN.ordinal());
        }
        return compound;
    }

    public FluidModule1.FluidDirection getFluidDirection() {
        return this.fluidDirection;
    }

    public int getMaxTransfer() {
        return this.maxTransfer;
    }

    public boolean isForceEmpty() {
        return this.forceEmpty;
    }

    private /* synthetic */ Boolean lambda$tryPourOutFluid$7(BlockState blockstate, World world, BlockPos pos, boolean isNotSolid, boolean isReplaceable, boolean playSound, IFluidHandlerItem handler) {
        FluidStack toPlace = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (toPlace.getAmount() < 1000) {
            return false;
        }
        Fluid fluid = toPlace.getFluid();
        if (!this.getFilter().testFluid(toPlace.getFluid())) {
            return false;
        }
        Block block = blockstate.func_177230_c();
        if (world.func_175623_d(pos) || isNotSolid || isReplaceable || block instanceof ILiquidContainer && ((ILiquidContainer)block).func_204510_a((IBlockReader)world, pos, blockstate, toPlace.getFluid())) {
            if (world.field_73011_w.func_177500_n() && fluid.func_207185_a(FluidTags.field_206959_a)) {
                this.playEvaporationEffects(world, pos);
            } else if (block instanceof ILiquidContainer) {
                IFluidState still;
                IFluidState iFluidState = still = fluid instanceof FlowingFluid ? ((FlowingFluid)fluid).func_207204_a(false) : fluid.func_207188_f();
                if (((ILiquidContainer)block).func_204509_a((IWorld)world, pos, blockstate, still) && playSound) {
                    this.playEmptySound(world, pos, fluid);
                }
            } else {
                if (playSound) {
                    this.playEmptySound(world, pos, fluid);
                }
                if (isNotSolid || isReplaceable) {
                    world.func_175655_b(pos, true);
                }
                world.func_180501_a(pos, fluid.func_207188_f().func_206883_i(), 3);
            }
            return true;
        }
        return false;
    }
}

