/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Logging {
    private static Logging instance = null;
    public static long prevTicks = -1L;
    private Logger logger = LogManager.getLogger((String)"mcjtylib");
    public static boolean debugMode = false;
    public static ForgeConfigSpec.BooleanValue doLogging;

    private Logging() {
        instance = this;
    }

    private static Logging getInstance() {
        if (instance == null) {
            instance = new Logging();
        }
        return instance;
    }

    public static void logError(String msg) {
        Logging.getLogger().log(Level.ERROR, msg);
    }

    public static void log(World world, TileEntity te, String message) {
        if (((Boolean)doLogging.get()).booleanValue()) {
            long ticks = world.func_82737_E();
            if (ticks != prevTicks) {
                prevTicks = ticks;
                Logging.getInstance().logger.log(Level.INFO, "=== Time " + ticks + " ===");
            }
            String id = te.func_174877_v().func_177958_n() + "," + te.func_174877_v().func_177956_o() + "," + te.func_174877_v().func_177952_p() + ": ";
            Logging.getInstance().logger.log(Level.INFO, id + message);
        }
    }

    public static Logger getLogger() {
        return Logging.getInstance().logger;
    }

    public static void logError(String msg, Throwable e) {
        Logging.getLogger().error(msg, e);
    }

    public static void log(String message) {
        Logging.getInstance().logger.log(Level.INFO, message);
    }

    public static void logDebug(String message) {
        if (debugMode) {
            Logging.getInstance().logger.log(Level.INFO, message);
        }
    }

    public static void message(@Nonnull PlayerEntity player, String message) {
        player.func_146105_b((ITextComponent)new StringTextComponent(message), false);
    }

    public static void warn(@Nonnull PlayerEntity player, String message) {
        player.func_146105_b(new StringTextComponent(message).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), false);
    }
}

