/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.GuiParser;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackTools {
    private static Set<ResourceLocation> commonTags = null;

    @Nonnull
    public static ItemStack extractItem(@Nullable TileEntity tileEntity, int slot, int amount) {
        if (tileEntity == null) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> handler.extractItem(slot, amount, false)).orElse((Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public static ItemStack getStack(@Nullable TileEntity tileEntity, int slot) {
        if (tileEntity == null) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> handler.getStackInSlot(slot)).orElse((Object)ItemStack.field_190927_a);
    }

    public static GuiParser.GuiCommand itemStackToGuiCommand(String name, ItemStack item) {
        GuiParser.GuiCommand object = new GuiParser.GuiCommand(name);
        object.parameter(item.func_77973_b().getRegistryName().toString());
        object.parameter(item.func_190916_E());
        if (item.func_77942_o()) {
            String string = item.func_77978_p().toString();
            object.command(new GuiParser.GuiCommand("tag").parameter(string));
        }
        return object;
    }

    public static ItemStack guiCommandToItemStack(GuiParser.GuiCommand obj) {
        String itemName = obj.getOptionalPar(0, "minecraft:stick");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        int amount = obj.getOptionalPar(1, 1);
        ItemStack stack = new ItemStack((IItemProvider)item, amount);
        obj.findCommand("tag").ifPresent(cmd -> {
            try {
                CompoundNBT nbt = JsonToNBT.func_180713_a((String)cmd.getOptionalPar(0, ""));
                stack.func_77982_d(nbt);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        });
        return stack;
    }

    public static void addCommonTags(Collection<ResourceLocation> fromItem, Set<ResourceLocation> tags) {
        ItemStackTools.findCommonTags();
        for (ResourceLocation id : fromItem) {
            if (!commonTags.contains(id)) continue;
            tags.add(id);
        }
    }

    public static boolean hasCommonTag(Collection<ResourceLocation> fromItem) {
        ItemStackTools.findCommonTags();
        for (ResourceLocation id : fromItem) {
            if (!commonTags.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static void findCommonTags() {
        if (commonTags == null) {
            commonTags = new HashSet<ResourceLocation>();
            commonTags.add(BlockTags.field_203436_u.func_199886_b());
            commonTags.add(BlockTags.field_219748_G.func_199886_b());
            commonTags.add(BlockTags.field_200030_g.func_199886_b());
            commonTags.add(BlockTags.field_206952_E.func_199886_b());
            commonTags.add(BlockTags.field_200031_h.func_199886_b());
            commonTags.add(BlockTags.field_203437_y.func_199886_b());
            commonTags.add(BlockTags.field_203292_x.func_199886_b());
            commonTags.add(BlockTags.field_199897_a.func_199886_b());
            commonTags.add(BlockTags.field_200028_e.func_199886_b());
            commonTags.add(BlockTags.field_226152_ab_.func_199886_b());
            commonTags.add(BlockTags.field_199898_b.func_199886_b());
            commonTags.add(BlockTags.field_203291_w.func_199886_b());
            commonTags.add(Tags.Blocks.GLASS.func_199886_b());
            commonTags.add(Tags.Blocks.GLASS_PANES.func_199886_b());
            commonTags.add(Tags.Blocks.CHESTS.func_199886_b());
            commonTags.add(Tags.Blocks.COBBLESTONE.func_199886_b());
            commonTags.add(Tags.Blocks.DIRT.func_199886_b());
            commonTags.add(Tags.Blocks.NETHERRACK.func_199886_b());
            commonTags.add(Tags.Blocks.OBSIDIAN.func_199886_b());
            commonTags.add(Tags.Blocks.GRAVEL.func_199886_b());
            commonTags.add(Tags.Blocks.SANDSTONE.func_199886_b());
            commonTags.add(Tags.Blocks.END_STONES.func_199886_b());
            commonTags.add(Tags.Blocks.STONE.func_199886_b());
            commonTags.add(Tags.Blocks.ORES_COAL.func_199886_b());
            commonTags.add(Tags.Blocks.ORES_DIAMOND.func_199886_b());
            commonTags.add(Tags.Blocks.ORES_EMERALD.func_199886_b());
            commonTags.add(Tags.Blocks.ORES_GOLD.func_199886_b());
            commonTags.add(Tags.Blocks.ORES_REDSTONE.func_199886_b());
            commonTags.add(Tags.Blocks.ORES_QUARTZ.func_199886_b());
            commonTags.add(Tags.Blocks.ORES_IRON.func_199886_b());
            commonTags.add(Tags.Blocks.ORES_LAPIS.func_199886_b());
            commonTags.add(new ResourceLocation("forge", "ores/copper"));
            commonTags.add(new ResourceLocation("forge", "ores/tin"));
            commonTags.add(new ResourceLocation("forge", "ores/silver"));
            commonTags.add(new ResourceLocation("forge", "ores/manganese"));
            commonTags.add(new ResourceLocation("forge", "ores/platinum"));
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_COAL.func_199886_b());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_DIAMOND.func_199886_b());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_EMERALD.func_199886_b());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_GOLD.func_199886_b());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_REDSTONE.func_199886_b());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_QUARTZ.func_199886_b());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_IRON.func_199886_b());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_LAPIS.func_199886_b());
            commonTags.add(new ResourceLocation("forge", "storage_blocks/copper"));
            commonTags.add(new ResourceLocation("forge", "storage_blocks/tin"));
            commonTags.add(new ResourceLocation("forge", "storage_blocks/silver"));
            commonTags.add(new ResourceLocation("forge", "storage_blocks/manganese"));
            commonTags.add(new ResourceLocation("forge", "storage_blocks/platinum"));
        }
    }
}

