/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryTools {
    public static int getInventorySize(TileEntity tileEntity) {
        if (tileEntity == null) {
            return 0;
        }
        return (Integer)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(IItemHandler::getSlots).orElse((Object)0);
    }

    public static boolean isInventory(TileEntity te) {
        return te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
    }

    public static Stream<ItemStack> getItems(TileEntity tileEntity, Predicate<ItemStack> predicate) {
        Stream.Builder builder = Stream.builder();
        if (tileEntity != null) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack itemStack = handler.getStackInSlot(i);
                    if (itemStack.func_190926_b() || !predicate.test(itemStack)) continue;
                    builder.add(itemStack);
                }
            });
        }
        return builder.build();
    }

    @Nonnull
    public static ItemStack getFirstMatchingItem(TileEntity tileEntity, Predicate<ItemStack> predicate) {
        if (tileEntity != null) {
            return (ItemStack)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack itemStack = handler.getStackInSlot(i);
                    if (itemStack.func_190926_b() || !predicate.test(itemStack)) continue;
                    return itemStack;
                }
                return ItemStack.field_190927_a;
            }).orElse((Object)ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack insertItem(World world, BlockPos pos, Direction direction, @Nonnull ItemStack s) {
        TileEntity te = world.func_175625_s(direction == null ? pos : pos.func_177972_a(direction));
        if (te != null) {
            Direction opposite = direction == null ? null : direction.func_176734_d();
            return (ItemStack)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)s, (boolean)false)).orElse((Object)ItemStack.field_190927_a);
        }
        return s;
    }

    public static boolean isItemStackConsideredEqual(ItemStack result, ItemStack itemstack1) {
        return !itemstack1.func_190926_b() && itemstack1.func_77973_b() == result.func_77973_b() && result.func_77952_i() == itemstack1.func_77952_i() && ItemStack.func_77970_a((ItemStack)result, (ItemStack)itemstack1);
    }

    @Nonnull
    public static ItemStack insertItemRanged(IItemHandler dest, @Nonnull ItemStack stack, int start, int stop, boolean simulate) {
        if (dest == null || stack.func_190926_b()) {
            return stack;
        }
        for (int i = start; i < stop; ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

