/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.network.SendPreferencesToClientHelper;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSendPreferencesToClient {
    private int buffX;
    private int buffY;
    private GuiStyle style;

    public PacketSendPreferencesToClient(ByteBuf buf) {
        this.buffX = buf.readInt();
        this.buffY = buf.readInt();
        this.style = GuiStyle.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.buffX);
        buf.writeInt(this.buffY);
        buf.writeInt(this.style.ordinal());
    }

    public PacketSendPreferencesToClient(int buffX, int buffY, GuiStyle style) {
        this.buffX = buffX;
        this.buffY = buffY;
        this.style = style;
    }

    public int getBuffX() {
        return this.buffX;
    }

    public int getBuffY() {
        return this.buffY;
    }

    public GuiStyle getStyle() {
        return this.style;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> SendPreferencesToClientHelper.setPreferences(this));
        ctx.setPacketHandled(true);
    }
}

