/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import mcjty.lib.McJtyLib;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.PacketOpenManual;
import mcjty.lib.network.PacketSetGuiStyle;
import mcjty.lib.preferences.PreferencesProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class GuiSideWindow {
    protected GuiStyle style;
    protected Window sideWindow;
    private Button guiButton;
    private Button helpButton;
    private int sideLeft;
    private int sideTop;
    private final ResourceLocation manual;
    private final ResourceLocation manualNode;
    private final int page;

    public GuiSideWindow(ResourceLocation manual, ResourceLocation manualNode, int page) {
        this.manual = manual;
        this.manualNode = manualNode;
        this.page = page;
    }

    public void initGui(ModBase modBase, Minecraft mc, Screen gui, int guiLeft, int guiTop, int xSize, int ySize) {
        this.style = (GuiStyle)((Object)McJtyLib.getPreferencesProperties((PlayerEntity)mc.field_71439_g).map(PreferencesProperties::getStyle).orElse((Object)GuiStyle.STYLE_FLAT_GRADIENT));
        this.helpButton = ((Button)Widgets.button(1, 1, 16, 16, "?").tooltips(new String[]{"Open manual"})).event(() -> this.help(modBase, mc));
        this.guiButton = Widgets.button(1, 19, 16, 16, "s").event(() -> this.changeStyle(McJtyLib.networkHandler));
        this.setStyleTooltip();
        Panel sidePanel = (Panel)Widgets.positional().children(this.guiButton, this.helpButton);
        this.sideLeft = guiLeft + xSize;
        this.sideTop = guiTop + (ySize - 20) / 2 - 8;
        sidePanel.bounds(this.sideLeft, this.sideTop, 20, 40);
        this.sideWindow = new Window(gui, sidePanel);
    }

    private void help(ModBase modBase, Minecraft mc) {
        if (this.manual != null) {
            McJtyLib.networkHandler.sendToServer((Object)new PacketOpenManual(this.manual, this.manualNode, this.page));
        }
    }

    private void setStyleTooltip() {
        this.guiButton.tooltips(new String[]{"Gui style:", this.style.getStyle()});
    }

    private void changeStyle(SimpleChannel network) {
        int next = this.style.ordinal() + 1;
        if (next >= GuiStyle.values().length) {
            next = 0;
        }
        this.style = GuiStyle.values()[next];
        network.sendToServer((Object)new PacketSetGuiStyle(this.style.getStyle()));
        this.setStyleTooltip();
    }

    public Window getWindow() {
        return this.sideWindow;
    }
}

