/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.varia.LogicFacing;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;

public abstract class BaseBlockStateProvider
extends BlockStateProvider {
    public BaseBlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    public ModelFile frontBasedModel(String modelName, ResourceLocation texture) {
        return this.models().cube(modelName, new ResourceLocation("rftoolsbase", "block/base/machinebottom"), new ResourceLocation("rftoolsbase", "block/base/machinetop"), texture, new ResourceLocation("rftoolsbase", "block/base/machineside"), new ResourceLocation("rftoolsbase", "block/base/machineside"), new ResourceLocation("rftoolsbase", "block/base/machineside"));
    }

    public ModelFile topBasedModel(String modelName, ResourceLocation texture) {
        return this.models().cube(modelName, new ResourceLocation("rftoolsbase", "block/base/machinebottom"), texture, new ResourceLocation("rftoolsbase", "block/base/machineside"), new ResourceLocation("rftoolsbase", "block/base/machineside"), new ResourceLocation("rftoolsbase", "block/base/machineside"), new ResourceLocation("rftoolsbase", "block/base/machineside"));
    }

    public ModelFile logicSlabModel(String modelName, ResourceLocation texture, ModelBuilder.FaceRotation faceRotation) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/" + modelName)).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block")));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 4.0f, 16.0f).face(Direction.DOWN).cullface(Direction.DOWN).texture("down").end().face(Direction.UP).texture("up").uvs(0.0f, 0.0f, 16.0f, 16.0f).rotation(faceRotation).end().face(Direction.EAST).cullface(Direction.EAST).texture("side").end().face(Direction.WEST).cullface(Direction.WEST).texture("side").end().face(Direction.NORTH).cullface(Direction.NORTH).texture("side").end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("side").end().end()).texture("side", new ResourceLocation("rftoolsbase", "block/base/machineside"))).texture("down", new ResourceLocation("rftoolsbase", "block/base/machinebottom"))).texture("up", texture);
        return model;
    }

    public void logicSlabBlock(LogicSlabBlock block, String modelPrefix, ResourceLocation topTexture) {
        ModelFile[] models = new ModelFile[]{this.logicSlabModel(modelPrefix + "_0", topTexture, ModelBuilder.FaceRotation.ZERO), this.logicSlabModel(modelPrefix + "_1", topTexture, ModelBuilder.FaceRotation.UPSIDE_DOWN), this.logicSlabModel(modelPrefix + "_2", topTexture, ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90), this.logicSlabModel(modelPrefix + "_3", topTexture, ModelBuilder.FaceRotation.CLOCKWISE_90)};
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (LogicFacing value : LogicFacing.VALUES) {
            Direction direction = value.getSide();
            this.applyLogicSlabRotation((ConfiguredModel.Builder<VariantBlockStateBuilder>)builder.partialState().with(LogicSlabBlock.LOGIC_FACING, (Comparable)((Object)value)).modelForState().modelFile(models[value.getRotationStep()]), direction);
        }
    }

    public void applyLogicSlabRotation(ConfiguredModel.Builder<VariantBlockStateBuilder> builder, Direction direction) {
        switch (direction) {
            case UP: {
                builder.rotationX(180).addModel();
                break;
            }
            case DOWN: {
                builder.addModel();
                break;
            }
            case NORTH: {
                builder.rotationX(-90).addModel();
                break;
            }
            case SOUTH: {
                builder.rotationX(90).addModel();
                break;
            }
            case EAST: {
                builder.rotationX(90).rotationY(270).addModel();
                break;
            }
            case WEST: {
                builder.rotationX(90).rotationY(90).addModel();
            }
        }
    }

    public void applyRotation(ConfiguredModel.Builder<VariantBlockStateBuilder> builder, Direction direction) {
        switch (direction) {
            case DOWN: {
                builder.rotationX(90).addModel();
                break;
            }
            case UP: {
                builder.rotationX(-90).addModel();
                break;
            }
            case NORTH: {
                builder.addModel();
                break;
            }
            case SOUTH: {
                builder.rotationY(180).addModel();
                break;
            }
            case WEST: {
                builder.rotationY(270).addModel();
                break;
            }
            case EAST: {
                builder.rotationY(90).addModel();
            }
        }
    }

    public void applyHorizRotation(ConfiguredModel.Builder<VariantBlockStateBuilder> builder, Direction direction) {
        switch (direction) {
            case NORTH: {
                builder.addModel();
                break;
            }
            case SOUTH: {
                builder.rotationY(180).addModel();
                break;
            }
            case WEST: {
                builder.rotationY(270).addModel();
                break;
            }
            case EAST: {
                builder.rotationY(90).addModel();
            }
        }
    }

    public void singleTextureBlock(Block block, String modelName, String textureName) {
        ModelBuilder model = this.models().cubeAll(modelName, this.modLoc(textureName));
        this.simpleBlock(block, (ModelFile)model);
    }

    public VariantBlockStateBuilder horizontalOrientedBlock(Block block, ModelFile model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH).modelForState().modelFile(model).addModel();
        builder.partialState().with((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH).modelForState().modelFile(model).rotationY(180).addModel();
        builder.partialState().with((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.WEST).modelForState().modelFile(model).rotationY(270).addModel();
        builder.partialState().with((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST).modelForState().modelFile(model).rotationY(90).addModel();
        return builder;
    }

    public VariantBlockStateBuilder orientedBlock(Block block, ModelFile model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH).modelForState().modelFile(model).addModel();
        builder.partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.SOUTH).modelForState().modelFile(model).rotationY(180).addModel();
        builder.partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.WEST).modelForState().modelFile(model).rotationY(270).addModel();
        builder.partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST).modelForState().modelFile(model).rotationY(90).addModel();
        builder.partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.UP).modelForState().modelFile(model).rotationX(-90).addModel();
        builder.partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN).modelForState().modelFile(model).rotationX(90).addModel();
        return builder;
    }

    protected void createFrame(BlockModelBuilder dimCellFrame, String txtName, float thick) {
        this.createFrame(dimCellFrame, txtName, thick, true, true);
    }

    protected void createFrame(BlockModelBuilder dimCellFrame, String txtName, float thick, boolean doTop, boolean doBottom) {
        this.innerCube(dimCellFrame, txtName, 0.0f, 0.0f, 0.0f, thick, 16.0f, thick);
        this.innerCube(dimCellFrame, txtName, 16.0f - thick, 0.0f, 0.0f, 16.0f, 16.0f, thick);
        this.innerCube(dimCellFrame, txtName, 0.0f, 0.0f, 16.0f - thick, thick, 16.0f, 16.0f);
        this.innerCube(dimCellFrame, txtName, 16.0f - thick, 0.0f, 16.0f - thick, 16.0f, 16.0f, 16.0f);
        if (doTop) {
            this.innerCube(dimCellFrame, txtName, thick, 16.0f - thick, 0.0f, 16.0f - thick, 16.0f, thick);
            this.innerCube(dimCellFrame, txtName, thick, 16.0f - thick, 16.0f - thick, 16.0f - thick, 16.0f, 16.0f);
            this.innerCube(dimCellFrame, txtName, 0.0f, 16.0f - thick, thick, thick, 16.0f, 16.0f - thick);
            this.innerCube(dimCellFrame, txtName, 16.0f - thick, 16.0f - thick, thick, 16.0f, 16.0f, 16.0f - thick);
        }
        if (doBottom) {
            this.innerCube(dimCellFrame, txtName, thick, 0.0f, 0.0f, 16.0f - thick, thick, thick);
            this.innerCube(dimCellFrame, txtName, thick, 0.0f, 16.0f - thick, 16.0f - thick, thick, 16.0f);
            this.innerCube(dimCellFrame, txtName, 0.0f, 0.0f, thick, thick, thick, 16.0f - thick);
            this.innerCube(dimCellFrame, txtName, 16.0f - thick, 0.0f, thick, 16.0f, thick, 16.0f - thick);
        }
    }

    protected void innerCube(BlockModelBuilder builder, String txtName, float fx, float fy, float fz, float tx, float ty, float tz) {
        builder.element().from(fx, fy, fz).to(tx, ty, tz).allFaces((direction, faceBuilder) -> faceBuilder.texture(txtName)).end();
    }
}

