/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.api.container;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mcjty.lib.api.container.IGenericContainer;
import mcjty.lib.tileentity.GenericEnergyStorage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class DefaultContainerProvider<C extends IGenericContainer>
implements INamedContainerProvider {
    private final String name;
    private BiFunction<Integer, PlayerEntity, C> containerSupplier;
    private Supplier<? extends IItemHandler> itemHandler = () -> null;
    private Supplier<? extends GenericEnergyStorage> energyHandler = () -> null;
    private List<IntReferenceHolder> integerListeners = new ArrayList<IntReferenceHolder>();
    private List<IntReferenceHolder> shortListeners = new ArrayList<IntReferenceHolder>();

    public DefaultContainerProvider(String name) {
        this.name = name;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.name);
    }

    public DefaultContainerProvider<C> containerSupplier(BiFunction<Integer, PlayerEntity, C> containerSupplier) {
        this.containerSupplier = containerSupplier;
        return this;
    }

    public DefaultContainerProvider<C> itemHandler(LazyOptional<? extends IItemHandler> itemHandler) {
        this.itemHandler = () -> (IItemHandler)itemHandler.map(h -> h).orElseThrow(RuntimeException::new);
        return this;
    }

    public DefaultContainerProvider<C> itemHandler(Supplier<? extends IItemHandler> itemHandler) {
        this.itemHandler = itemHandler;
        return this;
    }

    public DefaultContainerProvider<C> energyHandler(LazyOptional<? extends GenericEnergyStorage> energyHandler) {
        this.energyHandler = () -> (GenericEnergyStorage)energyHandler.map(h -> h).orElseThrow(RuntimeException::new);
        return this;
    }

    public DefaultContainerProvider<C> energyHandler(Supplier<? extends GenericEnergyStorage> energyHandler) {
        this.energyHandler = energyHandler;
        return this;
    }

    public DefaultContainerProvider<C> integerListener(IntReferenceHolder holder) {
        this.integerListeners.add(holder);
        return this;
    }

    public DefaultContainerProvider<C> shortListener(IntReferenceHolder holder) {
        this.shortListeners.add(holder);
        return this;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        IGenericContainer container = (IGenericContainer)this.containerSupplier.apply(windowId, playerEntity);
        IItemHandler itemHandler = this.itemHandler.get();
        container.setupInventories(itemHandler, playerInventory);
        GenericEnergyStorage energyHandler = this.energyHandler.get();
        if (energyHandler != null) {
            energyHandler.addIntegerListeners(container);
        }
        for (IntReferenceHolder listener : this.integerListeners) {
            container.addIntegerListener(listener);
        }
        for (IntReferenceHolder listener : this.shortListeners) {
            container.addShortListener(listener);
        }
        return container.getAsContainer();
    }
}

