/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus;

import com.stal111.forbidden_arcanus.block.CandelabraBlock;
import com.stal111.forbidden_arcanus.block.ModStandingSignBlock;
import com.stal111.forbidden_arcanus.block.ModWallSignBlock;
import com.stal111.forbidden_arcanus.block.tileentity.container.ModContainers;
import com.stal111.forbidden_arcanus.config.Config;
import com.stal111.forbidden_arcanus.event.LootTableListener;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.ForbiddenmiconPageLoadListener;
import com.stal111.forbidden_arcanus.init.ModBlocks;
import com.stal111.forbidden_arcanus.init.ModEffects;
import com.stal111.forbidden_arcanus.init.ModEnchantments;
import com.stal111.forbidden_arcanus.init.ModEntities;
import com.stal111.forbidden_arcanus.init.ModFeatures;
import com.stal111.forbidden_arcanus.init.ModItems;
import com.stal111.forbidden_arcanus.init.ModParticles;
import com.stal111.forbidden_arcanus.init.ModRecipeSerializers;
import com.stal111.forbidden_arcanus.init.ModTileEntities;
import com.stal111.forbidden_arcanus.item.ModItemGroup;
import com.stal111.forbidden_arcanus.item.block.WallFloorOrCeilingItem;
import com.stal111.forbidden_arcanus.particle.ModBreakingParticle;
import com.stal111.forbidden_arcanus.particle.SoulParticle;
import com.stal111.forbidden_arcanus.proxy.ClientProxy;
import com.stal111.forbidden_arcanus.proxy.IProxy;
import com.stal111.forbidden_arcanus.proxy.ServerProxy;
import com.stal111.forbidden_arcanus.recipe.AwkwardPotionBrewingRecipe;
import com.stal111.forbidden_arcanus.sound.ModSounds;
import com.stal111.forbidden_arcanus.util.Data;
import com.stal111.forbidden_arcanus.util.ModUtils;
import com.stal111.forbidden_arcanus.util.ModWoodType;
import com.stal111.forbidden_arcanus.world.gen.OreGenerator;
import com.stal111.forbidden_arcanus.world.gen.WorldGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="forbidden_arcanus")
public class Main {
    public static final String MOD_ID = "forbidden_arcanus";
    public static final Logger LOGGER = LogManager.getLogger((String)"forbidden_arcanus");
    public static final ItemGroup FORBIDDEN_ARCANUS = new ModItemGroup("forbidden_arcanus");
    public static final Block EDELWOOD_SIGN = (Block)new ModStandingSignBlock(Block.Properties.func_200950_a((Block)Blocks.field_222384_bX), ModWoodType.EDELWOOD).setRegistryName(ModUtils.location("edelwood_sign"));
    public static final Block EDELWOOD_WALL_SIGN = (Block)new ModWallSignBlock(Block.Properties.func_200950_a((Block)Blocks.field_222392_ch).func_222379_b(EDELWOOD_SIGN), ModWoodType.EDELWOOD).setRegistryName(ModUtils.location("edelwood_wall_sign"));
    public static final Block CHERRYWOOD_SIGN = (Block)new ModStandingSignBlock(Block.Properties.func_200950_a((Block)Blocks.field_222384_bX), ModWoodType.CHERRYWOOD).setRegistryName(ModUtils.location("cherrywood_sign"));
    public static final Block CHERRYWOOD_WALL_SIGN = (Block)new ModWallSignBlock(Block.Properties.func_200950_a((Block)Blocks.field_222392_ch).func_222379_b(CHERRYWOOD_SIGN), ModWoodType.CHERRYWOOD).setRegistryName(ModUtils.location("cherrywood_wall_sign"));
    public static final Block MYSTERYWOOD_SIGN = (Block)new ModStandingSignBlock(Block.Properties.func_200950_a((Block)Blocks.field_222384_bX), ModWoodType.MYSTERYWOOD).setRegistryName(ModUtils.location("mysterywood_sign"));
    public static final Block MYSTERYWOOD_WALL_SIGN = (Block)new ModWallSignBlock(Block.Properties.func_200950_a((Block)Blocks.field_222392_ch).func_222379_b(MYSTERYWOOD_SIGN), ModWoodType.MYSTERYWOOD).setRegistryName(ModUtils.location("mysterywood_wall_sign"));
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    private static final Data DATA = new Data();
    public static final ForbiddenmiconPageLoadListener PAGE_LOADER = new ForbiddenmiconPageLoadListener();
    public static Main instance;

    public Main() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(modEventBus);
        ModTileEntities.TILE_ENTITIES.register(modEventBus);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
        ModEffects.EFFECTS.register(modEventBus);
        modEventBus.addGenericListener(GlobalLootModifierSerializer.class, LootTableListener::registerGlobalModifiers);
        Data.PARTICLE_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        DATA.subscribeEvents(FMLJavaModLoadingContext.get().getModEventBus());
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::serverAboutToStart);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_CONFIG);
        Config.loadConfig(Config.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("forbidden_arcanus-client.toml").toString());
        Config.loadConfig(Config.SERVER_CONFIG, FMLPaths.CONFIGDIR.get().resolve("forbidden_arcanus-server.toml").toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        proxy.init();
        ModWoodType.register(ModWoodType.EDELWOOD);
        ModWoodType.register(ModWoodType.CHERRYWOOD);
        ModWoodType.register(ModWoodType.MYSTERYWOOD);
        OreGenerator.setupOreGen();
        WorldGenerator.setupWorldGen();
        ModUtils.addStrippable(ModBlocks.CHERRYWOOD_LOG.getBlock(), ModBlocks.STRIPPED_CHERRYWOOD_LOG.getBlock());
        ModUtils.addStrippable(ModBlocks.CHERRYWOOD.getBlock(), ModBlocks.STRIPPED_CHERRYWOOD.getBlock());
        ModUtils.addStrippable(ModBlocks.MYSTERYWOOD_LOG.getBlock(), ModBlocks.STRIPPED_MYSTERYWOOD_LOG.getBlock());
        ModUtils.addStrippable(ModBlocks.MYSTERYWOOD.getBlock(), ModBlocks.STRIPPED_MYSTERYWOOD.getBlock());
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AwkwardPotionBrewingRecipe());
    }

    @SubscribeEvent
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        System.out.println("SERVER ABOUT TO START!");
        event.getServer().field_195576_ac.func_219534_a((IFutureReloadListener)PAGE_LOADER);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            for (ModBlocks block : ModBlocks.values()) {
                event.getRegistry().register((IForgeRegistryEntry)block.getBlock());
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            for (ModBlocks block : ModBlocks.values()) {
                BlockItem item;
                if (block.hasItem()) {
                    if (block.hasSpecialItem()) {
                        event.getRegistry().register((IForgeRegistryEntry)block.getItem());
                        continue;
                    }
                    item = new BlockItem(block.getBlock(), ModItems.properties());
                    item.setRegistryName(ModUtils.location(block.getName()));
                    event.getRegistry().register((IForgeRegistryEntry)item);
                    continue;
                }
                if (!(block.getBlock() instanceof CandelabraBlock)) continue;
                item = new WallFloorOrCeilingItem(block.getBlock(), (Block)ForgeRegistries.BLOCKS.getValue(ModUtils.location("wall_" + block.getBlock().getRegistryName().func_110623_a())), (Block)ForgeRegistries.BLOCKS.getValue(ModUtils.location("hanging_" + block.getBlock().getRegistryName().func_110623_a())), ModItems.properties());
                item.setRegistryName(ModUtils.location(block.getName()));
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        }

        @SubscribeEvent
        public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
            ModContainers.register(event);
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            for (ModEntities entity : ModEntities.values()) {
                event.getRegistry().register(entity.get());
            }
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
            ModSounds.register(event);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void registerFactories(ParticleFactoryRegisterEvent event) {
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.SOUL.get(), SoulParticle.Factory::new);
            Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.ITEM_SEED_BULLET.get(), (IParticleFactory)new ModBreakingParticle.Factory());
        }

        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            for (ModFeatures feature : ModFeatures.values()) {
                event.getRegistry().register((IForgeRegistryEntry)feature.getFeature());
            }
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            for (ModRecipeSerializers recipe : ModRecipeSerializers.values()) {
                event.getRegistry().register(recipe.getRecipe());
            }
        }
    }
}

