/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.net;

import java.util.function.Supplier;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageClear {
    private final int id;
    private final boolean forced;

    public MessageClear(int id, boolean forced) {
        this.id = id;
        this.forced = forced;
    }

    public static MessageClear decode(PacketBuffer buf) {
        byte id = buf.readByte();
        boolean force = buf.readBoolean();
        return new MessageClear(id, force);
    }

    public static void encode(MessageClear message, PacketBuffer buf) {
        buf.writeByte(message.id);
        buf.writeBoolean(message.forced);
    }

    public static void handle(MessageClear message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            TweakProvider<Container> tweakProvider;
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            Container container = player.field_71070_bA;
            if (container != null && (tweakProvider = CraftingTweaksProviderManager.getProvider(container)) != null) {
                tweakProvider.clearGrid((PlayerEntity)player, container, message.id, message.forced);
            }
        });
    }
}

