/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;

public class CraftingRecipeAppendix
extends RecipeAppendix<IRecipe<CraftingInventory>> {
    private static final int SLOT_OFFSET_X = 5;
    private static final int SLOT_OFFSET_Y = 5;
    private static final int START_X_RESULT = 84;
    private static final AdvancedButtonEnum[] INPUT = new AdvancedButtonEnum[9];
    private static final AdvancedButtonEnum RESULT;

    public CraftingRecipeAppendix(IInfoBook infoBook, IRecipe<CraftingInventory> recipe) {
        super(infoBook, recipe);
    }

    @Override
    protected int getWidth() {
        return 104;
    }

    @Override
    protected int getHeightInner() {
        return 58;
    }

    @Override
    protected String getUnlocalizedTitle() {
        return "tile.workbench.name";
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        for (int i = 0; i < 9; ++i) {
            this.renderItemHolders.put(INPUT[i], new RecipeAppendix.ItemButton(this.getInfoBook()));
        }
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawElementInner(ScreenInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int j;
        int i;
        gui.drawArrowRight(x + 63 - 3, y + 5 + 16 + 2);
        int tick = this.getTick(gui);
        ItemStack[] grid = new ItemStack[9];
        ItemStack result = this.prepareItemStack(((IRecipe)this.recipe).func_77571_b(), tick);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                grid[i + j * 3] = this.prepareItemStacks(Lists.newArrayList((Object[])this.getItemStacks(i + j * 3).func_193365_a()), tick);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.renderItem(gui, x + 21 * i, y + 21 * j, grid[i + j * 3], mx, my, INPUT[i + j * 3]);
            }
        }
        this.renderItem(gui, x + 84, y + 21, result, mx, my, RESULT);
        this.renderItem(gui, x + 63, y + 5 + 16, new ItemStack((IItemProvider)Blocks.field_150462_ai), mx, my, false, null);
    }

    private static NonNullList<Ingredient> formatShapedGrid(NonNullList<Ingredient> itemStacksRaw, int width, int height) {
        int rawIndex = 0;
        NonNullList itemStacks = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                itemStacks.set(y * 3 + x, itemStacksRaw.get(rawIndex++));
                if (rawIndex >= itemStacksRaw.size()) break;
            }
            if (rawIndex >= itemStacksRaw.size()) break;
        }
        return itemStacks;
    }

    protected Ingredient getItemStacks(int index) {
        NonNullList<Ingredient> ingredients;
        if (this.recipe instanceof ShapedRecipe) {
            ingredients = CraftingRecipeAppendix.formatShapedGrid((NonNullList<Ingredient>)((ShapedRecipe)this.recipe).func_192400_c(), ((ShapedRecipe)this.recipe).getRecipeWidth(), ((ShapedRecipe)this.recipe).getRecipeHeight());
        } else if (this.recipe instanceof ShapelessRecipe) {
            ingredients = ((IRecipe)this.recipe).func_192400_c();
        } else {
            this.getInfoBook().getMod().log(Level.ERROR, "Recipe of type " + ((IRecipe)this.recipe).getClass() + " is not supported.");
            return Ingredient.field_193370_a;
        }
        if (ingredients.size() <= index) {
            return Ingredient.field_193370_a;
        }
        return (Ingredient)ingredients.get(index);
    }

    static {
        for (int i = 0; i < 9; ++i) {
            CraftingRecipeAppendix.INPUT[i] = AdvancedButtonEnum.create();
        }
        RESULT = AdvancedButtonEnum.create();
    }
}

