/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;

public final class TileHelpers {
    public static <T> Optional<T> getSafeTile(DimPos dimPos, Class<T> targetClazz) {
        World world = dimPos.getWorld(true);
        if (world == null) {
            return Optional.empty();
        }
        return TileHelpers.getSafeTile((IBlockReader)world, dimPos.getBlockPos(), targetClazz);
    }

    public static <T> Optional<T> getSafeTile(IBlockReader world, BlockPos pos, Class<T> targetClazz) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(targetClazz.cast(tile));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public static <C> LazyOptional<C> getCapability(DimPos dimPos, Capability<C> capability) {
        World world = dimPos.getWorld(true);
        if (world == null) {
            return LazyOptional.empty();
        }
        return TileHelpers.getCapability((IBlockReader)world, dimPos.getBlockPos(), null, capability);
    }

    public static <C> LazyOptional<C> getCapability(DimPos dimPos, Direction side, Capability<C> capability) {
        World world = dimPos.getWorld(true);
        if (world == null) {
            return LazyOptional.empty();
        }
        return TileHelpers.getCapability((IBlockReader)world, dimPos.getBlockPos(), side, capability);
    }

    public static <C> LazyOptional<C> getCapability(IBlockReader world, BlockPos pos, Capability<C> capability) {
        return TileHelpers.getCapability(world, pos, null, capability);
    }

    public static <C> LazyOptional<C> getCapability(IBlockReader world, BlockPos pos, Direction side, Capability<C> capability) {
        TileEntity tile = TileHelpers.getSafeTile(world, pos, TileEntity.class).orElse(null);
        if (tile != null) {
            return tile.getCapability(capability, side);
        }
        return LazyOptional.empty();
    }
}

