/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.item.ItemInformationProvider;

public abstract class ItemConfig
extends ExtendedConfigForge<ItemConfig, Item>
implements IModelProviderConfig {
    @OnlyIn(value=Dist.CLIENT)
    public ModelResourceLocation dynamicItemVariantLocation;

    public ItemConfig(ModBase mod, String namedId, Function<ItemConfig, ? extends Item> elementConstructor) {
        super(mod, namedId, elementConstructor);
        if (MinecraftHelpers.isClientSide()) {
            this.dynamicItemVariantLocation = null;
        }
    }

    @Override
    public String getModelName(ItemStack itemStack) {
        return this.getNamedId();
    }

    @Override
    public String getTranslationKey() {
        return "items." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public String getFullTranslationKey() {
        return "item." + this.getTranslationKey() + ".name";
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.ITEM;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelResourceLocation registerDynamicModel() {
        String blockName = this.getMod().getModId() + ":" + this.getNamedId();
        ModelResourceLocation itemLocation = new ModelResourceLocation(blockName, "inventory");
        return itemLocation;
    }

    @Override
    public void onForgeRegistered() {
        super.onForgeRegistered();
        ItemInformationProvider.registerItem((Item)this.getInstance());
    }

    public ItemGroup getTargetTab() {
        return this.getMod().getDefaultItemGroup();
    }

    @Override
    public IForgeRegistry<Item> getRegistry() {
        return ForgeRegistries.ITEMS;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColorHandler() {
        return null;
    }
}

