/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.forge.clothconfig2.gui.entries.AbstractTextFieldListListEntry;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DoubleListListEntry
extends AbstractTextFieldListListEntry<Double, DoubleListCell, DoubleListListEntry> {
    private double minimum = Double.NEGATIVE_INFINITY;
    private double maximum = Double.POSITIVE_INFINITY;

    @Deprecated
    public DoubleListListEntry(String fieldName, List<Double> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Double>> saveConsumer, Supplier<List<Double>> defaultValue, String resetButtonKey) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    public DoubleListListEntry(String fieldName, List<Double> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Double>> saveConsumer, Supplier<List<Double>> defaultValue, String resetButtonKey, boolean requiresRestart) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, true, true);
    }

    @Deprecated
    public DoubleListListEntry(String fieldName, List<Double> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Double>> saveConsumer, Supplier<List<Double>> defaultValue, String resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, DoubleListCell::new);
    }

    public DoubleListListEntry setMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public DoubleListListEntry setMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public DoubleListListEntry self() {
        return this;
    }

    public static class DoubleListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Double, DoubleListCell, DoubleListListEntry> {
        public DoubleListCell(Double value, DoubleListListEntry listListEntry) {
            super(value, listListEntry);
        }

        @Override
        @Nullable
        protected Double substituteDefault(@Nullable Double value) {
            if (value == null) {
                return 0.0;
            }
            return value;
        }

        @Override
        protected boolean isValidText(String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45 || c == 46);
        }

        @Override
        public Double getValue() {
            try {
                return Double.valueOf(this.widget.func_146179_b());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @Override
        public Optional<String> getError() {
            try {
                double i = Double.parseDouble(this.widget.func_146179_b());
                if (i > ((DoubleListListEntry)this.listListEntry).maximum) {
                    return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_large", (Object[])new Object[]{((DoubleListListEntry)this.listListEntry).maximum}));
                }
                if (i < ((DoubleListListEntry)this.listListEntry).minimum) {
                    return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_small", (Object[])new Object[]{((DoubleListListEntry)this.listListEntry).minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.not_valid_number_double", (Object[])new Object[0]));
            }
            return Optional.empty();
        }
    }
}

