/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.handler.ModSounds;

public class ItemDiviningRod
extends Item
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_divining.png");
    static final int COST = 3000;

    public ItemDiviningRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity p, @Nonnull Hand hand) {
        ItemStack stack = p.func_184586_b(hand);
        if (ManaItemHandler.instance().requestManaExactForTool(stack, p, 3000, true)) {
            if (world.field_72995_K) {
                int range = IManaProficiencyArmor.hasProficiency(p, stack) ? 20 : 15;
                long seedxor = world.field_73012_v.nextLong();
                this.doHighlight(world, new BlockPos((Entity)p), range, seedxor);
                p.func_184609_a(hand);
            } else {
                world.func_184148_a(null, p.func_226277_ct_(), p.func_226278_cu_(), p.func_226281_cx_(), ModSounds.divinationRod, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    private void doHighlight(World world, BlockPos pos, int range, long seedxor) {
        for (BlockPos pos_ : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range))) {
            BlockState state = world.func_180495_p(pos_);
            Block block = state.func_177230_c();
            if (!Tags.Blocks.ORES.func_199685_a_((Object)block)) continue;
            Random rand = new Random((long)block.getRegistryName().hashCode() ^ seedxor);
            WispParticleData data = WispParticleData.wisp(0.25f, rand.nextFloat(), rand.nextFloat(), rand.nextFloat(), 8.0f, false);
            world.func_195594_a((IParticleData)data, (double)((float)pos_.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)pos_.func_177956_o() + world.field_73012_v.nextFloat()), (double)((float)pos_.func_177952_p() + world.field_73012_v.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (tile.getCurrentMana() >= 3000 && tile.getElapsedFunctionalTicks() % 200 == 0 && tile.isEnabled()) {
            this.doHighlight(world, te.func_174877_v(), 18, te.func_174877_v().hashCode());
            tile.receiveMana(-3000);
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

