/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumPick;
import vazkii.botania.common.lib.ResourceLocationHelper;

@Mod.EventBusSubscriber(modid="botania", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DisposeModifier
extends LootModifier {
    protected DisposeModifier(ILootCondition[] conditions) {
        super(conditions);
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<GlobalLootModifierSerializer<?>> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName(ResourceLocationHelper.prefix("dispose")));
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity e = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (e != null && tool != null && !tool.func_190926_b()) {
            ItemElementiumPick.filterDisposable(generatedLoot, e, tool);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DisposeModifier> {
        public DisposeModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new DisposeModifier(conditions);
        }
    }
}

