/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.TileMod;

public class TileDistributor
extends TileMod
implements IManaReceiver,
ITickableTileEntity {
    @ObjectHolder(value="botania:mana_distributor")
    public static TileEntityType<TileDistributor> TYPE;
    private final List<IManaReceiver> validPools = new ArrayList<IManaReceiver>();

    public TileDistributor() {
        super(TYPE);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.validPools.clear();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            IManaReceiver receiver;
            TileEntity tileAt;
            BlockPos pos = this.field_174879_c.func_177972_a(dir);
            if (!this.field_145850_b.func_175667_e(pos) || !((tileAt = this.field_145850_b.func_175625_s(pos)) instanceof IManaPool) || tileAt.func_145837_r() || (receiver = (IManaReceiver)tileAt).isFull()) continue;
            this.validPools.add(receiver);
        }
    }

    @Override
    public int getCurrentMana() {
        return 0;
    }

    @Override
    public boolean isFull() {
        return this.validPools.isEmpty();
    }

    @Override
    public void receiveMana(int mana) {
        int tiles = this.validPools.size();
        if (tiles != 0) {
            int manaForEach = mana / tiles;
            for (IManaReceiver pool : this.validPools) {
                pool.receiveMana(manaForEach);
                TileEntity tile = (TileEntity)pool;
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, tile.func_174877_v());
            }
        }
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }
}

