/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.AcaciaFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.FlaxPlant;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.world.feature.NetherwoodTreeFeature;
import net.silentchaos512.gear.world.placement.NetherFloorWithExtra;
import net.silentchaos512.gear.world.placement.NetherFloorWithExtraConfig;
import net.silentchaos512.lib.world.feature.PlantFeature;

public final class ModWorldFeatures {
    public static final NetherwoodTreeFeature NETHERWOOD_TREE_FEATURE = new NetherwoodTreeFeature(TreeFeatureConfig::func_227338_a_);
    public static final Placement<NetherFloorWithExtraConfig> NETHER_FLOOR_WITH_EXTRA = new NetherFloorWithExtra(NetherFloorWithExtraConfig::deserialize);
    public static final TreeFeatureConfig NETHERWOOD_TREE_CONFIG = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.NETHERWOOD_LOG.asBlockState()), (BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.NETHERWOOD_LEAVES.asBlockState()), (FoliagePlacer)new AcaciaFoliagePlacer(2, 0)).func_225569_d_(5).func_227354_b_(2).func_227355_c_(2).func_227356_e_(0).func_227352_a_().setSapling((IPlantable)ModBlocks.NETHERWOOD_SAPLING.asBlock()).func_225568_b_();

    private ModWorldFeatures() {
    }

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(NETHERWOOD_TREE_FEATURE.setRegistryName(SilentGear.getId("netherwood_tree")));
    }

    public static void registerPlacements(RegistryEvent.Register<Placement<?>> event) {
        event.getRegistry().register(NETHER_FLOOR_WITH_EXTRA.setRegistryName(SilentGear.getId("nether_floor_with_extra")));
    }

    public static void addFeaturesToBiomes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() == Biome.Category.EXTREME_HILLS || biome.func_201856_r() == Biome.Category.PLAINS) {
                ModWorldFeatures.addWildFlax(biome);
            }
            if (biome.func_201856_r() != Biome.Category.NETHER) continue;
            ModWorldFeatures.addNetherwoodTrees(biome);
            ModWorldFeatures.addCrimsonIronOre(biome);
        }
    }

    private static void addWildFlax(Biome biome) {
        SilentGear.LOGGER.info("Add wild flax to {}", (Object)biome.getRegistryName());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, new PlantFeature(((FlaxPlant)ModBlocks.WILD_FLAX_PLANT.asBlock()).getMaturePlant(), 32, 4).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    private static void addNetherwoodTrees(Biome biome) {
        SilentGear.LOGGER.info("Add netherwood trees to {}", (Object)biome.getRegistryName());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, NETHERWOOD_TREE_FEATURE.func_225566_b_((IFeatureConfig)NETHERWOOD_TREE_CONFIG).func_227228_a_(NETHER_FLOOR_WITH_EXTRA.func_227446_a_((IPlacementConfig)new NetherFloorWithExtraConfig(1, 0.25f, 11, 32, 96))));
    }

    private static void addCrimsonIronOre(Biome biome) {
        SilentGear.LOGGER.info("Add crimson iron ore to {}", (Object)biome.getRegistryName());
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.CRIMSON_IRON_ORE.asBlockState(), 6)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(24, 24, 0, 120))));
    }
}

