/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class VoxelShapeUtils {
    public static VoxelShape rotateY(VoxelShape shape, int rotation) {
        HashSet rotatedShapes = new HashSet();
        shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(Block.func_208617_a((double)(8.0 - z1), (double)(y1 * 16.0), (double)(8.0 + x1), (double)(8.0 - z2), (double)(y2 * 16.0), (double)(8.0 + x2)));
                    break;
                }
                case 180: {
                    rotatedShapes.add(Block.func_208617_a((double)(8.0 - x1), (double)(y1 * 16.0), (double)(8.0 - z1), (double)(8.0 - x2), (double)(y2 * 16.0), (double)(8.0 - z2)));
                    break;
                }
                case 270: {
                    rotatedShapes.add(Block.func_208617_a((double)(8.0 + z1), (double)(y1 * 16.0), (double)(8.0 - x1), (double)(8.0 + z2), (double)(y2 * 16.0), (double)(8.0 - x2)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return (VoxelShape)rotatedShapes.stream().reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    }

    public static VoxelShape rotateX(VoxelShape shape, int rotation) {
        HashSet rotatedShapes = new HashSet();
        shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            y1 = y1 * 16.0 - 8.0;
            y2 = y2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(Block.func_208617_a((double)(x1 * 16.0), (double)(8.0 - z1), (double)(8.0 + y1), (double)(x2 * 16.0), (double)(8.0 - z2), (double)(8.0 + y2)));
                    break;
                }
                case 180: {
                    rotatedShapes.add(Block.func_208617_a((double)(x1 * 16.0), (double)(8.0 - z1), (double)(8.0 - y1), (double)(x2 * 16.0), (double)(8.0 - z2), (double)(8.0 - y2)));
                    break;
                }
                case 270: {
                    rotatedShapes.add(Block.func_208617_a((double)(x1 * 16.0), (double)(8.0 + z1), (double)(8.0 - y1), (double)(x2 * 16.0), (double)(8.0 + z2), (double)(8.0 - y2)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return (VoxelShape)rotatedShapes.stream().reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    }

    public static VoxelShape combine(IBooleanFunction func, VoxelShape ... shapes) {
        VoxelShape result = VoxelShapes.func_197880_a();
        for (VoxelShape shape : shapes) {
            result = VoxelShapes.func_197882_b((VoxelShape)result, (VoxelShape)shape, (IBooleanFunction)func);
        }
        return result.func_197753_c();
    }
}

