/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerRefinery;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryOutput;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class TileEntityRefineryController
extends TileEntityTickableBase
implements IRedstoneControlled,
IComparatorSupport,
ISerializableTanks,
INamedContainerProvider {
    @GuiSynced
    @DescSynced
    private final RefineryInputTank inputTank = new RefineryInputTank(16000);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.inputTank);
    @GuiSynced
    public final SmartSyncTank[] outputsSynced = new SmartSyncTank[4];
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private boolean blocked;
    @GuiSynced
    public int minTemp;
    @GuiSynced
    public int maxTemp;
    @DescSynced
    private int outputCount;
    @DescSynced
    private int lastProgress;
    private List<LazyOptional<IFluidHandler>> outputCache;
    private TemperatureRange operatingTemp = TemperatureRange.invalid();
    private RefineryRecipe currentRecipe;
    private int workTimer = 0;
    private int comparatorValue;
    private int prevOutputCount = -1;
    private boolean searchForRecipe = true;

    public TileEntityRefineryController() {
        super((TileEntityType)ModTileEntities.REFINERY.get());
        for (int i = 0; i < 4; ++i) {
            this.outputsSynced[i] = new SmartSyncTank(this, 16000);
        }
    }

    public static boolean isInputFluidValid(World world, Fluid fluid, int size) {
        RefineryRecipe recipe = PneumaticCraftRecipeType.REFINERY.findFirst(world, r -> r.getOutputs().size() <= size && FluidUtils.matchFluid(r.getInput(), fluid, true));
        return recipe != null;
    }

    private RefineryRecipe getRecipeFor(FluidStack fluid) {
        return PneumaticCraftRecipeType.REFINERY.stream(this.field_145850_b).filter(r -> r.getOutputs().size() <= this.outputCount).filter(r -> FluidUtils.matchFluid(r.getInput(), fluid, true)).max(Comparator.comparingInt(r2 -> r2.getOutputs().size())).orElse(null);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.inputTank.tick();
        if (!this.func_145831_w().field_72995_K) {
            this.lastProgress = 0;
            if (this.outputCache == null) {
                this.cacheRefineryOutputs();
            }
            this.outputCount = this.outputCache.size();
            if (this.prevOutputCount != this.outputCount) {
                this.searchForRecipe = true;
            }
            if (this.searchForRecipe) {
                this.currentRecipe = this.getRecipeFor(this.inputTank.getFluid());
                this.operatingTemp = this.currentRecipe == null ? TemperatureRange.invalid() : this.currentRecipe.getOperatingTemp();
                this.minTemp = this.operatingTemp.getMin();
                this.maxTemp = this.operatingTemp.getMax();
                this.searchForRecipe = false;
            }
            boolean hasWork = false;
            if (this.currentRecipe != null) {
                if (this.prevOutputCount != this.outputCount && this.outputCount > 1) {
                    this.redistributeFluids();
                }
                if (this.outputCount > 1 && this.redstoneAllows() && this.doRefiningStep(IFluidHandler.FluidAction.SIMULATE)) {
                    hasWork = true;
                    if (this.operatingTemp.inRange(this.heatExchanger.getTemperature()) && this.inputTank.getFluidAmount() >= this.currentRecipe.getInput().getAmount()) {
                        int progress = Math.max(0, ((int)this.heatExchanger.getTemperature() - (this.operatingTemp.getMin() - 30)) / 30);
                        progress = Math.min(5, progress);
                        this.heatExchanger.addHeat(-progress);
                        this.workTimer += progress;
                        while (this.workTimer >= 20 && this.inputTank.getFluidAmount() >= this.currentRecipe.getInput().getAmount()) {
                            this.workTimer -= 20;
                            this.doRefiningStep(IFluidHandler.FluidAction.EXECUTE);
                            this.inputTank.drain(this.currentRecipe.getInput().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        }
                        this.lastProgress = progress;
                    }
                } else {
                    this.workTimer = 0;
                }
            }
            IntStream.range(0, this.outputCount).forEach(i -> this.outputCache.get(i).ifPresent(h -> {
                this.outputsSynced[i].setFluid(h.getFluidInTank(0).copy());
                this.outputsSynced[i].tick();
            }));
            this.prevOutputCount = this.outputCount;
            this.updateComparatorValue(this.outputCount, hasWork);
        } else {
            TileEntityRefineryOutput teRO;
            if (this.lastProgress > 0 && (teRO = this.findAdjacentOutput()) != null) {
                for (int i2 = 0; i2 < this.lastProgress; ++i2) {
                    ClientUtils.emitParticles(this.func_145831_w(), teRO.func_174877_v().func_177967_a(Direction.UP, this.outputCount - 1), (IParticleData)ParticleTypes.field_197601_L);
                }
            }
            for (SmartSyncTank smartSyncTank : this.outputsSynced) {
                smartSyncTank.tick();
            }
        }
    }

    private void redistributeFluids() {
        int i;
        FluidTank[] tempTanks = new FluidTank[this.outputCount];
        for (i = 0; i < this.outputCount; ++i) {
            tempTanks[i] = new FluidTank(16000);
        }
        for (i = 0; i < this.outputCount; ++i) {
            FluidStack wantedFluid = this.currentRecipe.getOutputs().get(i);
            this.outputCache.get(i).ifPresent(outputHandler -> {
                FluidStack fluid = outputHandler.getFluidInTank(0);
                if (!fluid.isFluidEqual(wantedFluid)) {
                    for (int j = 0; j < this.currentRecipe.getOutputs().size(); ++j) {
                        if (!this.currentRecipe.getOutputs().get(j).isFluidEqual(fluid)) continue;
                        this.tryMoveFluid((IFluidHandler)outputHandler, (IFluidHandler)tempTanks[j]);
                        break;
                    }
                }
            });
        }
        for (i = 0; i < this.outputCount; ++i) {
            FluidTank tempTank = tempTanks[i];
            this.outputCache.get(i).ifPresent(arg_0 -> this.lambda$redistributeFluids$9((IFluidHandler)tempTank, arg_0));
        }
    }

    private void tryMoveFluid(IFluidHandler sourceHandler, IFluidHandler destHandler) {
        int moved;
        FluidStack fluid = sourceHandler.drain(sourceHandler.getTankCapacity(0), IFluidHandler.FluidAction.SIMULATE);
        if (!fluid.isEmpty() && (moved = destHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
            sourceHandler.drain(moved, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void cacheRefineryOutputs() {
        if (this.func_145837_r()) {
            return;
        }
        ArrayList<LazyOptional<IFluidHandler>> cache = new ArrayList<LazyOptional<IFluidHandler>>();
        TileEntityRefineryOutput output = this.findAdjacentOutput();
        while (output != null) {
            LazyOptional handler = output.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN);
            handler.addListener(l -> this.cacheRefineryOutputs());
            cache.add(handler);
            TileEntity te = output.getCachedNeighbor(Direction.UP);
            output = te instanceof TileEntityRefineryOutput ? (TileEntityRefineryOutput)te : null;
        }
        this.outputCache = cache;
    }

    public TileEntityRefineryOutput findAdjacentOutput() {
        for (Direction d : Direction.field_199792_n) {
            TileEntity te;
            if (d == Direction.DOWN || !((te = this.getCachedNeighbor(d)) instanceof TileEntityRefineryOutput)) continue;
            return (TileEntityRefineryOutput)te;
        }
        return null;
    }

    private boolean doRefiningStep(IFluidHandler.FluidAction action) {
        List<FluidStack> recipeOutputs = this.currentRecipe.getOutputs();
        for (int i = 0; i < this.outputCache.size() && i < recipeOutputs.size(); ++i) {
            FluidStack outFluid = recipeOutputs.get(i);
            int filled = (Integer)this.outputCache.get(i).map(h -> h.fill(outFluid, action)).orElse((Object)0);
            if (filled == outFluid.getAmount()) continue;
            this.blocked = true;
            return false;
        }
        this.blocked = false;
        return true;
    }

    @Override
    public boolean redstoneAllows() {
        int totalPower = this.poweredRedstone;
        TileEntityRefineryOutput refineryOutput = this.findAdjacentOutput();
        if (refineryOutput != null) {
            while (refineryOutput.getCachedNeighbor(Direction.UP) instanceof TileEntityRefineryOutput) {
                totalPower += refineryOutput.poweredRedstone;
                refineryOutput = (TileEntityRefineryOutput)refineryOutput.getCachedNeighbor(Direction.UP);
            }
        }
        switch (this.getRedstoneMode()) {
            case 0: {
                return true;
            }
            case 1: {
                return totalPower > 0;
            }
            case 2: {
                return totalPower == 0;
            }
        }
        return false;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74771_c("redstoneMode");
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    private void updateComparatorValue(int outputCount, boolean didWork) {
        int value;
        if (this.inputTank.getFluidAmount() < 10 || outputCount < 2 || this.currentRecipe == null || outputCount > this.currentRecipe.getOutputs().size()) {
            value = 0;
        } else {
            int n = value = didWork ? 15 : 0;
        }
        if (value != this.comparatorValue) {
            this.comparatorValue = value;
            this.func_145831_w().func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
    }

    @Override
    public int getComparatorValue() {
        return this.comparatorValue;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"OilTank", (Object)((Object)this.inputTank));
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerRefinery(i, playerInventory, this.func_174877_v());
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    private /* synthetic */ void lambda$redistributeFluids$9(IFluidHandler tempTank, IFluidHandler outputHandler) {
        this.tryMoveFluid(tempTank, outputHandler);
    }

    private class RefineryInputTank
    extends SmartSyncTank {
        private Fluid prevFluid;

        RefineryInputTank(int capacity) {
            super(TileEntityRefineryController.this, capacity);
        }

        public boolean isFluidValid(FluidStack fluid) {
            return this.getFluid().isFluidEqual(fluid) || TileEntityRefineryController.isInputFluidValid(TileEntityRefineryController.this.field_145850_b, fluid.getFluid(), 4);
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            Fluid newFluid = this.getFluid().getFluid();
            if (this.prevFluid != newFluid) {
                TileEntityRefineryController.this.searchForRecipe = true;
                this.prevFluid = newFluid;
            }
        }
    }
}

