/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.BlockElevatorBase;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerElevator;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorCaller;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityElevatorBase
extends TileEntityPneumaticBase
implements IGUITextFieldSensitive,
IRedstoneControlled,
IMinWorkingPressure,
IAirListener,
ICamouflageableTE,
INamedContainerProvider {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.elevator.button.redstone", (Object)"gui.tab.redstoneBehaviour.elevator.button.elevatorCallers");
    private static final float BUTTON_HEIGHT = 0.06f;
    private static final float BUTTON_SPACING = 0.02f;
    public float oldExtension;
    @DescSynced
    @LazySynced
    public float extension;
    @DescSynced
    private float targetExtension;
    @DescSynced
    float syncedSpeedMult;
    private boolean isStopped = true;
    private TileEntityElevatorBase coreElevator;
    private List<TileEntityElevatorBase> multiElevators;
    @DescSynced
    public int multiElevatorCount;
    @GuiSynced
    private int redstoneMode;
    public int[] floorHeights = new int[0];
    private HashMap<Integer, String> floorNames = new HashMap();
    @GuiSynced
    private int maxFloorHeight;
    private int redstoneInputLevel;
    @DescSynced
    private ItemStack camoStack = ItemStack.field_190927_a;
    private BlockState camoState;
    public float[] fakeFloorTextureUV;

    public TileEntityElevatorBase() {
        super((TileEntityType)ModTileEntities.ELEVATOR_BASE.get(), 5.0f, 7.0f, 10000, 4);
    }

    @Override
    public void func_73660_a() {
        float speedMultiplier;
        this.oldExtension = this.extension;
        if (!this.isCoreElevator()) {
            this.extension = 0.0f;
            return;
        }
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.isControlledByRedstone()) {
                this.handleRedstoneControl();
            }
            speedMultiplier = this.syncedSpeedMult = this.getSpeedMultiplierFromUpgrades();
        } else {
            speedMultiplier = (float)((double)this.syncedSpeedMult * PacketServerTickTime.tickTimeMultiplier);
        }
        SoundEvent soundName = null;
        if (this.extension < this.targetExtension) {
            float moveBy;
            if (!this.func_145831_w().field_72995_K && this.getPressure() < 3.0f) {
                this.targetExtension = this.extension;
                this.sendDescriptionPacket(256.0);
            }
            float f = moveBy = this.extension < this.targetExtension - 0.5f ? 0.05f * speedMultiplier : 0.02f * speedMultiplier;
            if (this.extension + moveBy > this.targetExtension) {
                this.extension = this.targetExtension;
                if (!this.func_145831_w().field_72995_K) {
                    this.updateFloors();
                }
            }
            if (this.isStopped) {
                soundName = (SoundEvent)ModSounds.ELEVATOR_RISING_START.get();
                this.isStopped = false;
                if (!(this.func_145831_w().field_72995_K || this.multiElevators != null && this != this.multiElevators.get(0))) {
                    PacketDistributor.TargetPoint tp = new PacketDistributor.TargetPoint((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 1024.0, this.field_145850_b.func_201675_m().func_186058_p());
                    NetworkHandler.sendToAllAround(new PacketPlayMovingSound(MovingSounds.Sound.ELEVATOR, this.getCoreElevator()), tp);
                }
            }
            float startingExtension = this.extension;
            while (this.extension < startingExtension + moveBy) {
                this.extension += 0.02f;
            }
            this.addAir((int)((this.oldExtension - this.extension) * 300.0f * (this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
        }
        if (this.extension > this.targetExtension) {
            float chargingSlowdown = 1.0f - (float)Math.min(4, this.getUpgrades(EnumUpgrade.CHARGING)) * 0.1f;
            this.extension = this.extension > this.targetExtension + 0.5f ? (this.extension -= 0.05f * this.syncedSpeedMult * chargingSlowdown) : (this.extension -= 0.02f * this.syncedSpeedMult * chargingSlowdown);
            if (this.extension < this.targetExtension) {
                this.extension = this.targetExtension;
                if (!this.func_145831_w().field_72995_K) {
                    this.updateFloors();
                }
            }
            if (this.isStopped) {
                soundName = (SoundEvent)ModSounds.ELEVATOR_RISING_START.get();
                this.isStopped = false;
                if (!(this.field_145850_b.field_72995_K || this.multiElevators != null && this != this.multiElevators.get(0))) {
                    PacketDistributor.TargetPoint tp = new PacketDistributor.TargetPoint((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 1024.0, this.field_145850_b.func_201675_m().func_186058_p());
                    NetworkHandler.sendToAllAround(new PacketPlayMovingSound(MovingSounds.Sound.ELEVATOR, this.getCoreElevator()), tp);
                }
            }
            if (this.getUpgrades(EnumUpgrade.CHARGING) > 0) {
                float mul = 0.15f * (float)Math.min(4, this.getUpgrades(EnumUpgrade.CHARGING));
                this.addAir((int)((this.oldExtension - this.extension) * 300.0f * mul * (this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
            }
        }
        if (this.oldExtension == this.extension && !this.isStopped) {
            soundName = (SoundEvent)ModSounds.ELEVATOR_RISING_STOP.get();
            this.isStopped = true;
        }
        if (soundName != null && this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, soundName, SoundCategory.BLOCKS, (float)PNCConfig.Client.Sound.elevatorVolumeStartStop, 1.0f, true);
        }
    }

    private void handleRedstoneControl() {
        float oldTargetExtension = this.targetExtension;
        float maxExtension = this.getMaxElevatorHeight();
        int redstoneInput = this.redstoneInputLevel;
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                redstoneInput = Math.max(this.redstoneInputLevel, base.redstoneInputLevel);
            }
        }
        this.targetExtension = (float)redstoneInput * maxExtension / 15.0f;
        if (this.targetExtension > this.oldExtension && this.getPressure() < 3.0f) {
            this.targetExtension = this.oldExtension;
        }
        if (oldTargetExtension != this.targetExtension) {
            this.sendDescPacketFromAllElevators();
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 1) {
                this.redstoneMode = 0;
            }
            if (this.multiElevators != null) {
                for (TileEntityElevatorBase base : this.multiElevators) {
                    while (base.redstoneMode != this.redstoneMode) {
                        base.handleGUIButtonPress(tag, shiftHeld, player);
                    }
                }
            }
            int i = -1;
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(Direction.DOWN));
            while (te instanceof TileEntityElevatorBase) {
                ((TileEntityElevatorBase)te).redstoneMode = this.redstoneMode;
                te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177982_a(0, --i, 0));
            }
        }
    }

    private boolean isControlledByRedstone() {
        return this.redstoneMode == 0;
    }

    @Override
    public boolean redstoneAllows() {
        return true;
    }

    private void updateRedstoneInputLevel() {
        if (this.multiElevators == null) {
            return;
        }
        int maxRedstone = 0;
        for (TileEntityElevatorBase base : this.multiElevators) {
            int i = 0;
            while (this.func_145831_w().func_180495_p(base.func_174877_v().func_177982_a(0, i, 0)).func_177230_c() == ModBlocks.ELEVATOR_BASE.get()) {
                maxRedstone = Math.max(maxRedstone, PneumaticCraftUtils.getRedstoneLevel(this.func_145831_w(), base.func_174877_v().func_177982_a(0, i, 0)));
                --i;
            }
        }
        for (TileEntityElevatorBase base : this.multiElevators) {
            base.redstoneInputLevel = maxRedstone;
        }
    }

    public float getMaxElevatorHeight() {
        int max = this.maxFloorHeight;
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                max = Math.max(max, base.maxFloorHeight);
            }
        }
        return max;
    }

    public void updateMaxElevatorHeight() {
        int i = -1;
        while (this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(0, ++i + 1, 0)).func_177230_c() == ModBlocks.ELEVATOR_FRAME.get()) {
        }
        int elevatorBases = 0;
        while (this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(0, -(++elevatorBases), 0)).func_177230_c() == ModBlocks.ELEVATOR_BASE.get()) {
        }
        this.maxFloorHeight = Math.min(i, elevatorBases * PNCConfig.Common.Machines.elevatorBaseBlocksPerBase);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.extension = tag.func_74760_g("extension");
        this.targetExtension = tag.func_74760_g("targetExtension");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        if (!tag.func_74764_b("maxFloorHeight")) {
            this.updateMaxElevatorHeight();
        } else {
            this.maxFloorHeight = tag.func_74762_e("maxFloorHeight");
        }
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(tag);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74776_a("extension", this.extension);
        tag.func_74776_a("targetExtension", this.targetExtension);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("maxFloorHeight", this.maxFloorHeight);
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, tag);
        return tag;
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.floorHeights = tag.func_74759_k("floorHeights");
        this.floorNames.clear();
        ListNBT floorNameList = tag.func_150295_c("floorNames", 10);
        for (int i = 0; i < floorNameList.size(); ++i) {
            CompoundNBT floorName = floorNameList.func_150305_b(i);
            this.floorNames.put(floorName.func_74762_e("floorHeight"), floorName.func_74779_i("floorName"));
        }
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        tag.func_74783_a("floorHeights", this.floorHeights);
        ListNBT floorNameList = new ListNBT();
        for (int key : this.floorNames.keySet()) {
            CompoundNBT floorNameTag = new CompoundNBT();
            floorNameTag.func_74768_a("floorHeight", key);
            floorNameTag.func_74778_a("floorName", this.floorNames.get(key));
            floorNameList.add((Object)floorNameTag);
        }
        tag.func_218657_a("floorNames", (INBT)floorNameList);
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.updateConnections();
    }

    private void connectAsMultiblock() {
        this.multiElevators = null;
        if (this.isCoreElevator()) {
            this.multiElevators = new ArrayList<TileEntityElevatorBase>();
            Stack<TileEntityElevatorBase> todo = new Stack<TileEntityElevatorBase>();
            todo.add(this);
            while (!todo.isEmpty()) {
                TileEntityElevatorBase curElevator = (TileEntityElevatorBase)todo.pop();
                if (!curElevator.isCoreElevator() || this.multiElevators.contains(curElevator)) continue;
                this.multiElevators.add(curElevator);
                curElevator.multiElevators = this.multiElevators;
                for (Direction face : PneumaticCraftUtils.HORIZONTALS) {
                    TileEntity te = curElevator.getCachedNeighbor(face);
                    if (!(te instanceof TileEntityElevatorBase) || te.func_145837_r()) continue;
                    todo.push((TileEntityElevatorBase)te);
                }
            }
            this.multiElevatorCount = this.multiElevators.size();
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.getCoreElevator().updateRedstoneInputLevel();
        this.connectAsMultiblock();
        this.updateConnections();
    }

    @Override
    public void onDescUpdate() {
        BlockState oldCamo = this.camoState;
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        if (oldCamo != this.camoState) {
            this.fakeFloorTextureUV = ClientUtils.getTextureUV(this.camoState, Direction.UP);
        }
        super.onDescUpdate();
    }

    private void updateConnections() {
        if (this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(Direction.UP)).func_177230_c() != ModBlocks.ELEVATOR_BASE.get()) {
            this.coreElevator = this;
            int i = -1;
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(Direction.DOWN));
            while (te instanceof TileEntityElevatorBase) {
                ((TileEntityElevatorBase)te).coreElevator = this;
                te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177982_a(0, --i, 0));
            }
        }
    }

    public void moveUpgradesFromAbove() {
        TileEntity brokenTE = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(Direction.UP));
        if (brokenTE instanceof TileEntityElevatorBase) {
            this.camoStack = ((TileEntityElevatorBase)brokenTE).camoStack;
            this.sendDescriptionPacket();
            for (int i = 0; i < this.getUpgradeHandler().getSlots(); ++i) {
                ItemStack stack = ((TileEntityElevatorBase)brokenTE).getUpgradeHandler().getStackInSlot(i);
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.getUpgradeHandler(), (ItemStack)stack, (boolean)false);
                if (!excess.func_190926_b()) {
                    PneumaticCraftUtils.dropItemOnGround(excess, this.field_145850_b, this.func_174877_v());
                }
                ((TileEntityElevatorBase)brokenTE).getUpgradeHandler().setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    public void updateFloors() {
        ArrayList<Integer> floorList = new ArrayList<Integer>();
        ArrayList<BlockPos> callerList = new ArrayList<BlockPos>();
        if (this.multiElevators != null) {
            int yOffset = 0;
            boolean shouldBreak = false;
            block0: while (!shouldBreak) {
                boolean registeredThisFloor = false;
                for (TileEntityElevatorBase base : this.multiElevators) {
                    for (Direction dir : PneumaticCraftUtils.HORIZONTALS) {
                        BlockPos checkPos = base.func_174877_v().func_177972_a(dir).func_177981_b(yOffset + 2);
                        if (base.field_145850_b.func_180495_p(checkPos).func_177230_c() != ModBlocks.ELEVATOR_CALLER.get()) continue;
                        callerList.add(checkPos);
                        if (!registeredThisFloor) {
                            floorList.add(yOffset);
                        }
                        registeredThisFloor = true;
                    }
                }
                ++yOffset;
                for (TileEntityElevatorBase base : this.multiElevators) {
                    if (base.field_145850_b.func_180495_p(base.func_174877_v().func_177981_b(yOffset)).func_177230_c() == ModBlocks.ELEVATOR_FRAME.get()) continue;
                    shouldBreak = true;
                    continue block0;
                }
            }
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.floorHeights = floorList.stream().mapToInt(Integer::intValue).toArray();
            }
        }
        TileEntityElevatorCaller.ElevatorButton[] elevatorButtons = new TileEntityElevatorCaller.ElevatorButton[this.floorHeights.length];
        int columns = (elevatorButtons.length - 1) / 12 + 1;
        for (int j = 0; j < columns; ++j) {
            for (int i = j * 12; i < this.floorHeights.length && i < j * 12 + 12; ++i) {
                elevatorButtons[i] = new TileEntityElevatorCaller.ElevatorButton(0.2f + 0.6f / (float)columns * (float)j, 0.5f + (float)(Math.min(this.floorHeights.length, 12) - 2) * 0.08f / 2.0f - (float)(i % 12) * 0.08f, 0.58f / (float)columns, 0.06f, i, this.floorHeights[i]);
                elevatorButtons[i].setColor((float)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f, 1.0f, (float)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f);
                String floorName = this.floorNames.get(this.floorHeights[i]);
                if (floorName != null) {
                    elevatorButtons[i].buttonText = floorName;
                    continue;
                }
                this.floorNames.put(this.floorHeights[i], elevatorButtons[i].buttonText);
            }
        }
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.floorNames = new HashMap<Integer, String>(this.floorNames);
            }
        }
        for (BlockPos p : callerList) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof TileEntityElevatorCaller)) continue;
            int callerFloorHeight = p.func_177956_o() - this.func_174877_v().func_177956_o() - 2;
            int callerFloor = -1;
            for (TileEntityElevatorCaller.ElevatorButton floor : elevatorButtons) {
                if (floor.floorHeight != callerFloorHeight) continue;
                callerFloor = floor.floorNumber;
                break;
            }
            if (callerFloor == -1) {
                Log.error("Error while updating elevator floors! This will cause a indexOutOfBoundsException, index = -1", new Object[0]);
            }
            ((TileEntityElevatorCaller)te).setEmittingRedstone(PneumaticCraftUtils.areFloatsEqual(this.targetExtension, this.extension, 0.1f) && PneumaticCraftUtils.areFloatsEqual(this.extension, callerFloorHeight, 0.1f));
            ((TileEntityElevatorCaller)te).setFloors(elevatorButtons, callerFloor);
        }
    }

    public void goToFloor(int floor) {
        if (this.getCoreElevator().isControlledByRedstone()) {
            this.getCoreElevator().handleGUIButtonPress("redstone", false, null);
        }
        if (floor >= 0 && floor < this.floorHeights.length) {
            this.setTargetHeight(this.floorHeights[floor]);
        }
        this.updateFloors();
        this.sendDescPacketFromAllElevators();
    }

    private void setTargetHeight(float height) {
        height = Math.min(height, this.getMaxElevatorHeight());
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.targetExtension = height;
            }
        }
    }

    public float getTargetExtension() {
        return this.targetExtension;
    }

    private void sendDescPacketFromAllElevators() {
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.sendDescriptionPacket(256.0);
            }
        } else {
            this.sendDescriptionPacket(256.0);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)((float)(this.func_174877_v().func_177956_o() + 1) + this.extension), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    public double func_145833_n() {
        return 65536.0;
    }

    private TileEntityElevatorBase getCoreElevator() {
        if (this.coreElevator == null || this.func_145831_w().field_72995_K && (this.func_145831_w().func_82737_E() & 0x3FL) == 0L) {
            this.coreElevator = BlockElevatorBase.getCoreTileEntity(this.func_145831_w(), this.func_174877_v());
        }
        return this.coreElevator;
    }

    public boolean isCoreElevator() {
        return this.getCoreElevator() == this;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP && side != Direction.DOWN || this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(side)).func_177230_c() != ModBlocks.ELEVATOR_BASE.get();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY && !this.isCoreElevator()) {
            return this.getCoreElevator().getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public List<IAirHandlerMachine> addConnectedPneumatics(List<IAirHandlerMachine> airHandlers) {
        TileEntity te = this.getTileCache()[Direction.DOWN.ordinal()].getTileEntity();
        if (te instanceof TileEntityElevatorBase) {
            TileEntityElevatorBase te1 = (TileEntityElevatorBase)te;
            List<IAirHandlerMachine.Connection> l = te1.airHandler.getConnectedAirHandlers(te1);
            airHandlers.addAll(l.stream().map(IAirHandlerMachine.Connection::getAirHandler).collect(Collectors.toList()));
        }
        return airHandlers;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.setFloorName(textFieldID, text);
    }

    @Override
    public String getText(int textFieldID) {
        return this.getFloorName(textFieldID);
    }

    public String getFloorName(int floor) {
        return floor < this.floorHeights.length ? this.floorNames.get(this.floorHeights[floor]) : "";
    }

    public void setFloorName(int floor, String name) {
        if (floor < this.floorHeights.length) {
            this.floorNames.put(this.floorHeights[floor], name);
            this.updateFloors();
        }
    }

    @Override
    public boolean isGuiUseableByPlayer(PlayerEntity par1EntityPlayer) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("setHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "height (in blocks)");
                TileEntityElevatorBase.this.setTargetHeight(((Double)args[0]).floatValue());
                if (TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone()) {
                    TileEntityElevatorBase.this.getCoreElevator().handleGUIButtonPress("redstone", false, null);
                }
                TileEntityElevatorBase.this.getCoreElevator().sendDescPacketFromAllElevators();
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getCurrentHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{Float.valueOf(((TileEntityElevatorBase)TileEntityElevatorBase.this).getCoreElevator().extension)};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getTargetHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{Float.valueOf(TileEntityElevatorBase.this.getCoreElevator().targetExtension)};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "true/false");
                if (((Boolean)args[0]).booleanValue() && TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone() || !((Boolean)args[0]).booleanValue() && !TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone()) {
                    TileEntityElevatorBase.this.getCoreElevator().handleGUIButtonPress("redstone", false, null);
                }
                return null;
            }
        });
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.0f;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        this.sendDescriptionPacket();
        this.func_70296_d();
    }

    @Override
    public String getRedstoneTabTitle() {
        return "gui.tab.redstoneBehaviour.elevator.controlBy";
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerElevator(i, playerInventory, this.func_174877_v());
    }
}

