/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer;
import me.desht.pneumaticcraft.common.block.BlockThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class JEIThermopneumaticProcessingPlantCategory
implements IRecipeCategory<ThermoPlantRecipe> {
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable icon;
    private final ITickTimer tickTimer;
    private final Map<ResourceLocation, WidgetTemperature> tempWidgets = new HashMap<ResourceLocation, WidgetTemperature>();
    private final IDrawableAnimated progressBar;

    JEIThermopneumaticProcessingPlantCategory() {
        this.icon = JEIPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()));
        this.background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_THERMOPNEUMATIC_PROCESSING_PLANT, 0, 0, 166, 70);
        this.localizedName = I18n.func_135052_a((String)((BlockThermopneumaticProcessingPlant)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()).func_149739_a(), (Object[])new Object[0]);
        this.tickTimer = JEIPlugin.jeiHelpers.getGuiHelper().createTickTimer(60, 60, false);
        IDrawableStatic d = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_THERMOPNEUMATIC_PROCESSING_PLANT, 176, 0, 48, 30);
        this.progressBar = JEIPlugin.jeiHelpers.getGuiHelper().createAnimatedDrawable(d, 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return ModCategoryUid.THERMO_PLANT;
    }

    public Class<? extends ThermoPlantRecipe> getRecipeClass() {
        return ThermoPlantRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ThermoPlantRecipe recipe, IIngredients ingredients) {
        if (!recipe.getInputFluid().func_203189_d()) {
            ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInputFluid().getFluidStacks()));
        }
        if (!recipe.getInputItem().func_203189_d()) {
            ingredients.setInputIngredients(Collections.singletonList(recipe.getInputItem()));
        }
        if (!recipe.getOutputFluid().isEmpty()) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutputFluid());
        }
        if (!recipe.getOutputItem().func_190926_b()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutputItem());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, ThermoPlantRecipe recipe, IIngredients ingredients) {
        FluidStack in = (FluidStack)((List)ingredients.getInputs(VanillaTypes.FLUID).get(0)).get(0);
        int inH = 64;
        int outH = 64;
        FluidStack out = FluidStack.EMPTY;
        if (!recipe.getOutputFluid().isEmpty()) {
            out = (FluidStack)((List)ingredients.getOutputs(VanillaTypes.FLUID).get(0)).get(0);
            if (in.getAmount() > out.getAmount()) {
                outH = Math.min(64, out.getAmount() * 64 / in.getAmount());
            } else {
                inH = Math.min(64, in.getAmount() * 64 / out.getAmount());
            }
        }
        if (!recipe.getInputFluid().func_203189_d()) {
            recipeLayout.getFluidStacks().init(0, true, 8, 3 + (64 - inH), 16, inH, in.getAmount(), false, Helpers.makeTankOverlay(inH));
            recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        }
        if (!recipe.getInputItem().func_203189_d()) {
            recipeLayout.getItemStacks().init(0, true, 32, 2);
            recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        if (!recipe.getOutputFluid().isEmpty()) {
            recipeLayout.getFluidStacks().init(1, false, 74, 3 + (64 - outH), 16, outH, out.getAmount(), false, Helpers.makeTankOverlay(outH));
            recipeLayout.getFluidStacks().set(1, recipe.getOutputFluid());
        }
        if (!recipe.getOutputItem().func_190926_b()) {
            recipeLayout.getItemStacks().init(1, false, 47, 50);
            recipeLayout.getItemStacks().set(1, recipe.getOutputItem());
        }
    }

    public void draw(ThermoPlantRecipe recipe, double mouseX, double mouseY) {
        if (recipe.getRequiredPressure() != 0.0f) {
            float pressure = recipe.getRequiredPressure() * ((float)this.tickTimer.getValue() / (float)this.tickTimer.getMaxValue());
            PressureGaugeRenderer.drawPressureGauge(Minecraft.func_71410_x().field_71466_p, -1.0f, 7.0f, 5.0f, recipe.getRequiredPressure(), pressure, 136, 42);
        }
        if (!recipe.getOperatingTemperature().isAny()) {
            WidgetTemperature w = this.tempWidgets.computeIfAbsent(recipe.func_199560_c(), id -> Helpers.makeTemperatureWidget(92, 12, recipe.getOperatingTemperature().getMin()));
            w.setTemperature((double)this.tickTimer.getValue() * ((double)w.getScales()[0] - 273.0) / (double)this.tickTimer.getMaxValue() + 273.0);
            w.render((int)mouseX, (int)mouseY, 0.0f);
        }
        this.progressBar.draw(25, 20);
    }

    public List<String> getTooltipStrings(ThermoPlantRecipe recipe, double mouseX, double mouseY) {
        ArrayList<String> res = new ArrayList<String>();
        WidgetTemperature w = this.tempWidgets.get(recipe.func_199560_c());
        if (w != null && w.isMouseOver(mouseX, mouseY)) {
            res.add(HeatUtil.formatHeatString(recipe.getOperatingTemperature().asString(TemperatureRange.TemperatureScale.CELSIUS)).func_150254_d());
        }
        if (recipe.getRequiredPressure() > 0.0f && mouseX >= 116.0 && mouseY >= 22.0 && mouseX <= 156.0 && mouseY <= 62.0) {
            res.add(I18n.func_135052_a((String)"gui.tooltip.pressure", (Object[])new Object[]{Float.valueOf(recipe.getRequiredPressure())}));
        }
        return res;
    }
}

