/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketClearRecipeCache;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.machine.AssemblyRecipeImpl;
import me.desht.pneumaticcraft.common.recipes.machine.ExplosionCraftingRecipeImpl;
import me.desht.pneumaticcraft.common.recipes.machine.HeatFrameCoolingRecipeImpl;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberRecipeImpl;
import me.desht.pneumaticcraft.common.recipes.machine.RefineryRecipeImpl;
import me.desht.pneumaticcraft.common.recipes.machine.ThermoPlantRecipeImpl;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.IForgeRegistry;

public class PneumaticCraftRecipeType<T extends PneumaticCraftRecipe>
implements IRecipeType<T> {
    private static final List<PneumaticCraftRecipeType<? extends PneumaticCraftRecipe>> types = new ArrayList<PneumaticCraftRecipeType<? extends PneumaticCraftRecipe>>();
    public static final PneumaticCraftRecipeType<AmadronOffer> AMADRON_OFFERS = PneumaticCraftRecipeType.registerType("amadron");
    public static final PneumaticCraftRecipeType<AssemblyRecipe> ASSEMBLY_LASER = PneumaticCraftRecipeType.registerType("assembly_laser");
    public static final PneumaticCraftRecipeType<AssemblyRecipe> ASSEMBLY_DRILL = PneumaticCraftRecipeType.registerType("assembly_drill");
    public static final PneumaticCraftRecipeType<AssemblyRecipe> ASSEMBLY_DRILL_LASER = PneumaticCraftRecipeType.registerType("assembly_drill_laser");
    public static final PneumaticCraftRecipeType<ExplosionCraftingRecipeImpl> EXPLOSION_CRAFTING = PneumaticCraftRecipeType.registerType("explosion_crafting");
    public static final PneumaticCraftRecipeType<HeatFrameCoolingRecipeImpl> HEAT_FRAME_COOLING = PneumaticCraftRecipeType.registerType("heat_frame_cooling");
    public static final PneumaticCraftRecipeType<PressureChamberRecipeImpl> PRESSURE_CHAMBER = PneumaticCraftRecipeType.registerType("pressure_chamber");
    public static final PneumaticCraftRecipeType<RefineryRecipeImpl> REFINERY = PneumaticCraftRecipeType.registerType("refinery");
    public static final PneumaticCraftRecipeType<ThermoPlantRecipeImpl> THERMO_PLANT = PneumaticCraftRecipeType.registerType("thermo_plant");
    private final Map<ResourceLocation, T> cachedRecipes = new HashMap<ResourceLocation, T>();
    private final ResourceLocation registryName;
    private static CacheReloadListener cacheReloadListener;

    private static <T extends PneumaticCraftRecipe> PneumaticCraftRecipeType<T> registerType(String name) {
        PneumaticCraftRecipeType<T> type = new PneumaticCraftRecipeType<T>(name);
        types.add(type);
        return type;
    }

    static void registerRecipeTypes(IForgeRegistry<IRecipeSerializer<?>> registry) {
        types.forEach(type -> {
            PneumaticCraftRecipeType cfr_ignored_0 = (PneumaticCraftRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)type.registryName, (Object)type);
        });
    }

    private PneumaticCraftRecipeType(String name) {
        this.registryName = PneumaticCraftUtils.RL(name);
    }

    public static CacheReloadListener getCacheReloadListener() {
        if (cacheReloadListener == null) {
            cacheReloadListener = new CacheReloadListener();
        }
        return cacheReloadListener;
    }

    public String toString() {
        return this.registryName.toString();
    }

    public static void clearCachedRecipes() {
        types.forEach(type -> type.cachedRecipes.clear());
        HeatFrameCoolingRecipeImpl.cacheMaxThresholdTemp(Collections.emptyList());
    }

    public Map<ResourceLocation, T> getRecipes(World world) {
        if (world == null && (world = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_)) == null) {
            return Collections.emptyMap();
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = world.func_199532_z();
            List recipes = recipeManager.func_215370_b((IRecipeType)this, (IInventory)PneumaticCraftRecipe.DummyIInventory.getInstance(), world);
            recipes.forEach(recipe -> this.cachedRecipes.put(recipe.func_199560_c(), recipe));
            if (this == ASSEMBLY_DRILL_LASER) {
                Collection<AssemblyRecipe> drillRecipes = ASSEMBLY_DRILL.getRecipes(world).values();
                Collection<AssemblyRecipe> laserRecipes = ASSEMBLY_LASER.getRecipes(world).values();
                AssemblyRecipeImpl.calculateAssemblyChain(drillRecipes, laserRecipes).forEach((id, recipe) -> {
                    PneumaticCraftRecipe cfr_ignored_0 = this.cachedRecipes.put((ResourceLocation)id, (T)recipe);
                });
            }
        }
        return this.cachedRecipes;
    }

    public Stream<T> stream(World world) {
        return this.getRecipes(world).values().stream();
    }

    public T findFirst(World world, Predicate<T> predicate) {
        return (T)((PneumaticCraftRecipe)this.stream(world).filter(predicate).findFirst().orElse(null));
    }

    public T getRecipe(World world, ResourceLocation recipeId) {
        return (T)((PneumaticCraftRecipe)this.getRecipes(world).get(recipeId));
    }

    public static class CacheReloadListener
    implements IFutureReloadListener {
        public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(() -> {
                PneumaticCraftRecipeType.clearCachedRecipes();
                NetworkHandler.sendToAll(new PacketClearRecipeCache());
            }, gameExecutor).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0));
        }
    }
}

