/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class AreaTypeSphere
extends AreaType {
    public static final String ID = "sphere";
    private EnumSphereType sphereType = EnumSphereType.FILLED;

    public AreaTypeSphere() {
        super(ID);
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        double radius = PneumaticCraftUtils.distBetween((Vec3i)p1, (Vec3i)p2);
        double radiusSq = radius * radius;
        double innerRadius = this.sphereType == EnumSphereType.HOLLOW ? radius - 1.0 : 0.0;
        double innerRadiusSq = innerRadius * innerRadius;
        minX = (int)((double)p1.func_177958_n() - radius - 1.0);
        minY = (int)((double)p1.func_177956_o() - radius - 1.0);
        minZ = (int)((double)p1.func_177952_p() - radius - 1.0);
        maxX = (int)((double)p1.func_177958_n() + radius + 1.0);
        maxY = (int)((double)p1.func_177956_o() + radius + 1.0);
        maxZ = (int)((double)p1.func_177952_p() + radius + 1.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double centerDistSq = PneumaticCraftUtils.distBetweenSq((Vec3i)p1, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    if (!(centerDistSq <= radiusSq) || !(centerDistSq >= innerRadiusSq)) continue;
                    areaAdder.accept(new BlockPos(x, y, z));
                }
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<EnumSphereType>("gui.progWidget.area.type.sphere.sphereType", EnumSphereType.class, () -> this.sphereType, sphereType -> {
            this.sphereType = sphereType;
        }));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("sphereType", (byte)this.sphereType.ordinal());
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        super.writeToPacket(buffer);
        buffer.writeByte(this.sphereType.ordinal());
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.sphereType = EnumSphereType.values()[buf.readByte()];
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.sphereType = EnumSphereType.values()[tag.func_74771_c("sphereType")];
    }

    private static enum EnumSphereType {
        FILLED("filled"),
        HOLLOW("hollow");

        private final String name;

        private EnumSphereType(String name) {
            this.name = "gui.progWidget.area.type.sphere.sphereType." + name;
        }

        public String toString() {
            return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
        }
    }
}

