/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class PacketUpdateTubeModule
extends LocationIntPacket {
    private Direction moduleSide;

    public PacketUpdateTubeModule() {
    }

    public PacketUpdateTubeModule(TubeModule module) {
        super(module.getTube().func_174877_v());
        this.moduleSide = module.getDirection();
    }

    public PacketUpdateTubeModule(PacketBuffer buffer) {
        super(buffer);
        this.moduleSide = Direction.func_82600_a((int)buffer.readByte());
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.writeByte((int)((byte)this.moduleSide.func_176745_a()));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TubeModule module;
            TileEntity te = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q().func_175625_s(this.pos);
            if (te instanceof TileEntityPressureTube && (module = ((TileEntityPressureTube)te).modules[this.moduleSide.func_176745_a()]) != null) {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                this.onModuleUpdate(module, (PlayerEntity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    protected abstract void onModuleUpdate(TubeModule var1, PlayerEntity var2);
}

