/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.semiblock.ItemSemiBlock;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.GuiConstants;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ItemLogisticsFrame
extends ItemSemiBlock
implements ColorHandlers.ITintableItem {
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        final ItemStack stack = player.func_184586_b(handIn);
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return stack.func_200301_q();
                }

                @Nullable
                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    return new ContainerLogistics(ItemLogisticsFrame.this.getContainerType(), i, playerInventory, -1);
                }
            }, buffer -> buffer.func_150787_b(-1));
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    protected abstract ContainerType<?> getContainerType();

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> curInfo, ITooltipFlag extraInfo) {
        super.func_77624_a(stack, worldIn, curInfo, extraInfo);
        ItemLogisticsFrame.addLogisticsTooltip(stack, worldIn, curInfo, ClientUtils.hasShiftDown());
    }

    public static void addLogisticsTooltip(ItemStack stack, World world, List<ITextComponent> curInfo, boolean sneaking) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("EntityTag") && stack.func_77973_b() instanceof ItemSemiBlock) {
            if (sneaking) {
                CompoundNBT tag = stack.func_77978_p().func_74775_l("EntityTag");
                if (tag.func_74767_n("invisible")) {
                    curInfo.add(GuiConstants.bullet().func_150257_a(PneumaticCraftUtils.xlate("gui.logistics_frame.invisible", new Object[0])).func_211708_a(TextFormatting.YELLOW));
                }
                if (tag.func_74767_n("matchDurability")) {
                    curInfo.add(GuiConstants.bullet().func_150257_a(PneumaticCraftUtils.xlate("gui.logistics_frame.matchDurability", new Object[0])).func_211708_a(TextFormatting.YELLOW));
                }
                if (tag.func_74767_n("matchNBT")) {
                    curInfo.add(GuiConstants.bullet().func_150257_a(PneumaticCraftUtils.xlate("gui.logistics_frame.matchNBT", new Object[0])).func_211708_a(TextFormatting.YELLOW));
                }
                if (tag.func_74767_n("matchModID")) {
                    curInfo.add(GuiConstants.bullet().func_150257_a(PneumaticCraftUtils.xlate("gui.logistics_frame.matchModId", new Object[0])).func_211708_a(TextFormatting.YELLOW));
                }
                boolean whitelist = tag.func_74767_n("whitelist");
                curInfo.add(PneumaticCraftUtils.xlate("gui.logistics_frame." + (whitelist ? "whitelist" : "blacklist"), new Object[0]).func_150258_a(":").func_211708_a(TextFormatting.YELLOW));
                ItemStackHandler handler = new ItemStackHandler();
                handler.deserializeNBT(tag.func_74775_l("filters"));
                ItemStack[] stacks = new ItemStack[handler.getSlots()];
                for (int i = 0; i < handler.getSlots(); ++i) {
                    stacks[i] = handler.getStackInSlot(i);
                }
                int l = curInfo.size();
                PneumaticCraftUtils.sortCombineItemStacksAndToString(curInfo, stacks, TextFormatting.YELLOW.toString() + "\u2022" + " ");
                if (curInfo.size() == l) {
                    curInfo.add(GuiConstants.bullet().func_211708_a(TextFormatting.YELLOW).func_150257_a(PneumaticCraftUtils.xlate("gui.misc.no_items", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.ITALIC})));
                }
                l = curInfo.size();
                EntityLogisticsFrame.FluidFilter fluidFilter = new EntityLogisticsFrame.FluidFilter();
                fluidFilter.deserializeNBT(tag.func_74775_l("fluidFilters"));
                for (int i = 0; i < fluidFilter.size(); ++i) {
                    FluidStack fluid = fluidFilter.get(i);
                    if (fluid.isEmpty()) continue;
                    curInfo.add(GuiConstants.bullet().func_150258_a(fluid.getAmount() + "mB ").func_150257_a(fluid.getDisplayName()).func_211708_a(TextFormatting.YELLOW));
                }
                if (curInfo.size() == l) {
                    curInfo.add(GuiConstants.bullet().func_211708_a(TextFormatting.YELLOW).func_150257_a(PneumaticCraftUtils.xlate("gui.misc.no_fluids", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.ITALIC})));
                }
            } else {
                curInfo.add(PneumaticCraftUtils.xlate("gui.logistics_frame.hasFilters", new Object[0]));
            }
        }
    }
}

