/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourCustomTransition;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourFurnace;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourHeatFrame;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public enum HeatBehaviourManager {
    INSTANCE;

    private final Map<ResourceLocation, Supplier<? extends HeatBehaviour>> behaviourRegistry = new HashMap<ResourceLocation, Supplier<? extends HeatBehaviour>>();

    public static HeatBehaviourManager getInstance() {
        return INSTANCE;
    }

    public void reload() {
        this.behaviourRegistry.clear();
        this.registerBehaviour(HeatBehaviourFurnace.ID, HeatBehaviourFurnace::new);
        this.registerBehaviour(HeatBehaviourHeatFrame.ID, HeatBehaviourHeatFrame::new);
        this.registerBehaviour(HeatBehaviourCustomTransition.ID, HeatBehaviourCustomTransition::new);
    }

    public void registerBehaviour(ResourceLocation id, Supplier<? extends HeatBehaviour> behaviour) {
        Validate.notNull(behaviour);
        Supplier<? extends HeatBehaviour> existing = this.behaviourRegistry.put(id, behaviour);
        if (existing != null) {
            Log.warning("Overriding heat behaviour " + id, new Object[0]);
        }
    }

    public <T extends HeatBehaviour> T createBehaviour(ResourceLocation id) {
        Supplier<? extends HeatBehaviour> behaviour = this.behaviourRegistry.get(id);
        if (behaviour != null) {
            return (T)behaviour.get();
        }
        Log.warning("No heat behaviour found for id: " + id, new Object[0]);
        return null;
    }

    public int addHeatBehaviours(World world, BlockPos pos, Direction direction, BiPredicate<IWorld, BlockPos> blockFilter, IHeatExchangerLogic logic, List<HeatBehaviour> list) {
        if (!blockFilter.test((IWorld)world, pos)) {
            return 0;
        }
        int s = list.size();
        for (Supplier<? extends HeatBehaviour> bSup : this.behaviourRegistry.values()) {
            HeatBehaviour behaviour = bSup.get().initialize(logic, world, pos, direction);
            if (!behaviour.isApplicable()) continue;
            list.add(behaviour);
        }
        return list.size() - s;
    }
}

