/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.heat.HeatRegistrationEvent;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.IProperty;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.exception.ExceptionUtils;

public enum BlockHeatProperties {
    INSTANCE;

    private static final String BLOCK_HEAT_PROPERTIES = "pneumaticcraft/block_heat_properties";
    private Map<ResourceLocation, CustomHeatEntry> customHeatEntries = new HashMap<ResourceLocation, CustomHeatEntry>();

    public static BlockHeatProperties getInstance() {
        return INSTANCE;
    }

    public CustomHeatEntry getCustomHeatEntry(Block block) {
        return this.customHeatEntries.get(block.getRegistryName());
    }

    public CustomHeatEntry getOrCreateCustomHeatEntry(Fluid fluid) {
        Block block = fluid.func_207188_f().func_206883_i().func_177230_c();
        if (block == Blocks.field_150350_a || block == null) {
            return null;
        }
        CustomHeatEntry entry = this.getCustomHeatEntry(block);
        if (entry == null) {
            entry = this.buildDefaultFluidEntry(block, fluid);
            this.customHeatEntries.put(block.getRegistryName(), entry);
        }
        return entry;
    }

    private void clear() {
        this.customHeatEntries.clear();
    }

    public void register(ResourceLocation id, CustomHeatEntry entry) {
        this.customHeatEntries.put(id, entry);
    }

    private CustomHeatEntry buildDefaultFluidEntry(Block block, Fluid fluid) {
        BlockState transformColdFlowing;
        BlockState transformCold;
        BlockState transformHotFlowing;
        BlockState transformHot;
        int temperature = fluid.getAttributes().getTemperature();
        if (fluid.getAttributes().getTemperature() >= 1300) {
            transformHot = null;
            transformHotFlowing = null;
            transformCold = Blocks.field_150343_Z.func_176223_P();
            transformColdFlowing = Blocks.field_150347_e.func_176223_P();
        } else {
            transformHot = Blocks.field_150350_a.func_176223_P();
            transformHotFlowing = Blocks.field_150350_a.func_176223_P();
            transformCold = Blocks.field_150432_aD.func_176223_P();
            transformColdFlowing = Blocks.field_150433_aE.func_176223_P();
        }
        return new CustomHeatEntry(block, transformHot, transformHotFlowing, transformCold, transformColdFlowing, PNCConfig.Common.Heat.defaultFluidHeatCapacity, temperature, PNCConfig.Common.Heat.defaultFluidThermalResistance, Collections.emptyMap());
    }

    public static class CustomHeatEntry {
        private final int heatCapacity;
        private final int temperature;
        private final double thermalResistance;
        private final Block block;
        private final BlockState transformHot;
        private final BlockState transformHotFlowing;
        private final BlockState transformCold;
        private final BlockState transformColdFlowing;
        private final ResourceLocation id;
        private final Map<String, String> predicates;
        private final IHeatExchangerLogic logic;

        CustomHeatEntry(Block block, BlockState transformHot, BlockState transformHotFlowing, BlockState transformCold, BlockState transformColdFlowing, int heatCapacity, int temperature, double thermalResistance, Map<String, String> predicates) {
            this.id = block.getRegistryName();
            this.heatCapacity = heatCapacity;
            this.block = block;
            this.transformHot = transformHot;
            this.transformHotFlowing = transformHotFlowing != null ? transformHotFlowing : transformHot;
            this.transformCold = transformCold;
            this.transformColdFlowing = transformColdFlowing != null ? transformColdFlowing : transformCold;
            this.temperature = temperature;
            this.thermalResistance = thermalResistance;
            this.predicates = predicates;
            this.logic = new HeatExchangerLogicConstant(temperature, thermalResistance);
        }

        CustomHeatEntry(Block block, int temperature, double thermalResistance) {
            this(block, null, null, null, null, 0, temperature, thermalResistance, Collections.emptyMap());
        }

        static CustomHeatEntry fromJson(JsonObject json) {
            int temperature;
            Fluid fluid;
            Block block;
            BlockState transformHot = null;
            BlockState transformHotFlowing = null;
            BlockState transformCold = null;
            BlockState transformColdFlowing = null;
            HashMap<String, String> predicates = new HashMap<String, String>();
            if (json.has("block") && json.has("fluid")) {
                throw new JsonSyntaxException("heat properties entry must have only one of \"block\" or \"fluid\" fields!");
            }
            if (json.has("block")) {
                ResourceLocation blockId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"block"));
                if (blockId.toString().equals("minecraft:air")) {
                    throw new JsonSyntaxException("minecraft:air block heat properties may not be changed!");
                }
                block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
                CustomHeatEntry.validateBlock(blockId, block);
                fluid = block.func_176223_P().func_204520_s().func_206886_c();
            } else if (json.has("fluid")) {
                ResourceLocation fluidId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"block"));
                fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
                if (fluid == Fluids.field_204541_a) {
                    throw new JsonSyntaxException("unknown fluid " + fluidId);
                }
                block = fluid.func_207188_f().func_206883_i().func_177230_c();
                CustomHeatEntry.validateBlock(fluidId, block);
            } else {
                throw new JsonSyntaxException("heat properties entry must have a \"block\" or \"fluid\" field!");
            }
            if (block == Blocks.field_150350_a) {
                return null;
            }
            int totalHeat = 0;
            if (json.has("heatCapacity")) {
                totalHeat = json.get("heatCapacity").getAsInt();
            } else if (fluid != Fluids.field_204541_a) {
                totalHeat = PNCConfig.Common.Heat.defaultFluidHeatCapacity;
            }
            if (totalHeat != 0) {
                transformHot = CustomHeatEntry.maybeGetBlock(block, json, "transformHot");
                transformHotFlowing = CustomHeatEntry.maybeGetBlock(block, json, "transformHotFlowing");
                transformCold = CustomHeatEntry.maybeGetBlock(block, json, "transformCold");
                transformColdFlowing = CustomHeatEntry.maybeGetBlock(block, json, "transformColdFlowing");
            }
            if (json.has("temperature")) {
                temperature = JSONUtils.func_151203_m((JsonObject)json, (String)"temperature");
            } else {
                if (fluid == Fluids.field_204541_a) {
                    throw new JsonSyntaxException(block.toString() + ": Non-fluid definitions must have a 'temperature' field!");
                }
                temperature = fluid.getAttributes().getTemperature();
            }
            double thermalResistance = json.has("thermalResistance") ? json.get("thermalResistance").getAsDouble() : (fluid == Fluids.field_204541_a ? PNCConfig.Common.Heat.defaultBlockThermalResistance : PNCConfig.Common.Heat.defaultFluidThermalResistance);
            if (json.has("statePredicate")) {
                json.getAsJsonObject("statePredicate").entrySet().forEach(entry -> {
                    if (block.func_176194_O().func_185920_a((String)entry.getKey()) == null) {
                        throw new JsonSyntaxException("unknown blockstate property " + (String)entry.getKey() + " for block" + block.getRegistryName());
                    }
                    predicates.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                });
            }
            return new CustomHeatEntry(block, transformHot, transformHotFlowing, transformCold, transformColdFlowing, totalHeat, temperature, thermalResistance, predicates);
        }

        public IHeatExchangerLogic getLogic() {
            return this.logic;
        }

        boolean testPredicates(BlockState state) {
            if (this.predicates.isEmpty()) {
                return true;
            }
            for (Map.Entry<String, String> entry : this.predicates.entrySet()) {
                IProperty iproperty = state.func_177230_c().func_176194_O().func_185920_a(entry.getKey());
                if (iproperty == null) {
                    return false;
                }
                Comparable comparable = iproperty.func_185929_b(entry.getValue()).orElse(null);
                if (comparable != null && state.func_177229_b(iproperty) == comparable) continue;
                return false;
            }
            return true;
        }

        private static void validateBlock(ResourceLocation blockId, Block block) {
            if (block == Blocks.field_150350_a) {
                String mod = blockId.func_110624_b();
                if (ModList.get().isLoaded(mod)) {
                    throw new JsonSyntaxException("unknown block id: " + blockId.toString());
                }
                Log.info("ignoring heat properties for %s: mod '%s' not loaded", blockId, mod);
            }
        }

        private static BlockState parseBlockState(String str) {
            try {
                BlockStateParser parser = new BlockStateParser(new StringReader(str), false).func_197243_a(false);
                return parser.func_197249_b();
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(String.format("invalid blockstate [%s] - %s", str, e.getMessage()));
            }
        }

        private static BlockState maybeGetBlock(Block b, JsonObject json, String field) {
            if (!json.has(field)) {
                return null;
            }
            JsonObject sub = json.get(field).getAsJsonObject();
            if (sub.has("block")) {
                return CustomHeatEntry.parseBlockState(JSONUtils.func_151200_h((JsonObject)sub, (String)"block"));
            }
            if (sub.has("fluid")) {
                ResourceLocation fluidId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)sub, (String)"fluid"));
                if (ForgeRegistries.FLUIDS.containsKey(fluidId)) {
                    return ((Fluid)ForgeRegistries.FLUIDS.getValue(fluidId)).func_207188_f().func_206883_i();
                }
                throw new JsonSyntaxException(String.format("unknown fluid '%s' for field '%s' in block '%s'", fluidId, field, b.getRegistryName()));
            }
            throw new JsonSyntaxException(String.format("block %s must have either a 'block' or 'fluid' section!", b.getRegistryName()));
        }

        public int getHeatCapacity() {
            return this.heatCapacity;
        }

        public int getTemperature() {
            return this.temperature;
        }

        public double getThermalResistance() {
            return this.thermalResistance;
        }

        public Block getBlock() {
            return this.block;
        }

        public BlockState getTransformHot() {
            return this.transformHot;
        }

        public BlockState getTransformCold() {
            return this.transformCold;
        }

        public BlockState getTransformHotFlowing() {
            return this.transformHotFlowing;
        }

        public BlockState getTransformColdFlowing() {
            return this.transformColdFlowing;
        }

        public ResourceLocation getId() {
            return this.id;
        }
    }

    public static class ReloadListener
    extends JsonReloadListener {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public ReloadListener() {
            super(GSON, BlockHeatProperties.BLOCK_HEAT_PROPERTIES);
        }

        protected void apply(Map<ResourceLocation, JsonObject> resourceList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
            BlockHeatProperties.getInstance().clear();
            resourceList.forEach((id, json) -> {
                try {
                    CustomHeatEntry entry = CustomHeatEntry.fromJson(json);
                    if (entry != null) {
                        BlockHeatProperties.getInstance().register(entry.getId(), entry);
                    }
                }
                catch (JsonParseException e) {
                    Log.error("can't load %s: %s", id, e.getMessage());
                    Log.error(ExceptionUtils.getStackTrace((Throwable)e), new Object[0]);
                }
            });
            HeatBehaviourManager.getInstance().reload();
            MinecraftForge.EVENT_BUS.post((Event)new HeatRegistrationEvent(HeatExchangerManager.getInstance()));
            this.registerDefaultFluidValues();
        }

        private void registerDefaultFluidValues() {
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                CustomHeatEntry entry;
                Block block;
                if (fluid == Fluids.field_204541_a || (block = fluid.func_207188_f().func_206883_i().func_177230_c()) == null || block == Blocks.field_150350_a || BlockHeatProperties.getInstance().getCustomHeatEntry(block) != null || (entry = BlockHeatProperties.getInstance().getOrCreateCustomHeatEntry(fluid)) != null) continue;
                Log.warning("unable to build custom heat entry for fluid %s (block %s) ", fluid.getRegistryName(), block.getRegistryName());
            }
        }
    }
}

