/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking;

import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import me.desht.pneumaticcraft.common.hacking.block.HackableButton;
import me.desht.pneumaticcraft.common.hacking.block.HackableDispenser;
import me.desht.pneumaticcraft.common.hacking.block.HackableDoor;
import me.desht.pneumaticcraft.common.hacking.block.HackableJukebox;
import me.desht.pneumaticcraft.common.hacking.block.HackableLever;
import me.desht.pneumaticcraft.common.hacking.block.HackableMobSpawner;
import me.desht.pneumaticcraft.common.hacking.block.HackableNoteblock;
import me.desht.pneumaticcraft.common.hacking.block.HackableSecurityStation;
import me.desht.pneumaticcraft.common.hacking.block.HackableSilverfish;
import me.desht.pneumaticcraft.common.hacking.block.HackableTNT;
import me.desht.pneumaticcraft.common.hacking.block.HackableTrapDoor;
import me.desht.pneumaticcraft.common.hacking.block.HackableTripwire;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBat;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBlaze;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCaveSpider;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCow;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCreeper;
import me.desht.pneumaticcraft.common.hacking.entity.HackableEnderman;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGhast;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGuardian;
import me.desht.pneumaticcraft.common.hacking.entity.HackableHorse;
import me.desht.pneumaticcraft.common.hacking.entity.HackableItemFrame;
import me.desht.pneumaticcraft.common.hacking.entity.HackableMobDisarm;
import me.desht.pneumaticcraft.common.hacking.entity.HackablePainting;
import me.desht.pneumaticcraft.common.hacking.entity.HackableSheep;
import me.desht.pneumaticcraft.common.hacking.entity.HackableShulker;
import me.desht.pneumaticcraft.common.hacking.entity.HackableTameable;
import me.desht.pneumaticcraft.common.hacking.entity.HackableVillager;
import me.desht.pneumaticcraft.common.hacking.entity.HackableWitch;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.apache.commons.lang3.tuple.Pair;

public class HackableHandler {
    private final Map<Entity, IHackableEntity> trackedHackableEntities = new HashMap<Entity, IHackableEntity>();
    private final Map<WorldAndCoord, Pair<Block, IHackableBlock>> trackedHackableBlocks = new HashMap<WorldAndCoord, Pair<Block, IHackableBlock>>();
    private static HackableHandler clientInstance;
    private static HackableHandler serverInstance;

    private static HackableHandler getInstance() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            if (clientInstance == null) {
                clientInstance = new HackableHandler();
            }
            return clientInstance;
        }
        if (serverInstance == null) {
            serverInstance = new HackableHandler();
        }
        return serverInstance;
    }

    public static void addDefaultEntries() {
        IPneumaticHelmetRegistry manager = PneumaticRegistry.getInstance().getHelmetRegistry();
        manager.addHackable(Blocks.field_150335_W, HackableTNT::new);
        manager.addHackable(Blocks.field_150474_ac, HackableMobSpawner::new);
        manager.addHackable(Blocks.field_150442_at, HackableLever::new);
        manager.addHackable(Blocks.field_150479_bC, HackableTripwire::new);
        manager.addHackable(Blocks.field_150367_z, HackableDispenser::new);
        manager.addHackable(Blocks.field_150409_cd, HackableDispenser::new);
        manager.addHackable((Block)ModBlocks.SECURITY_STATION.get(), HackableSecurityStation::new);
        manager.addHackable(Blocks.field_196687_dd, HackableSilverfish::new);
        manager.addHackable(Blocks.field_196694_dh, HackableSilverfish::new);
        manager.addHackable(Blocks.field_196692_dg, HackableSilverfish::new);
        manager.addHackable(Blocks.field_196690_df, HackableSilverfish::new);
        manager.addHackable(Blocks.field_196686_dc, HackableSilverfish::new);
        manager.addHackable(Blocks.field_196688_de, HackableSilverfish::new);
        manager.addHackable(Blocks.field_196586_al, HackableNoteblock::new);
        manager.addHackable(Blocks.field_150421_aI, HackableJukebox::new);
        manager.addHackable((Tag<Block>)BlockTags.field_200027_d, HackableButton::new);
        manager.addHackable((Tag<Block>)BlockTags.field_200029_f, HackableDoor::new);
        manager.addHackable((Tag<Block>)BlockTags.field_212185_E, HackableTrapDoor::new);
        manager.addHackable(LivingEntity.class, HackableMobDisarm::new);
        manager.addHackable(CreeperEntity.class, HackableCreeper::new);
        manager.addHackable(TameableEntity.class, HackableTameable::new);
        manager.addHackable(CowEntity.class, HackableCow::new);
        manager.addHackable(SheepEntity.class, HackableSheep::new);
        manager.addHackable(CaveSpiderEntity.class, HackableCaveSpider::new);
        manager.addHackable(BlazeEntity.class, HackableBlaze::new);
        manager.addHackable(GhastEntity.class, HackableGhast::new);
        manager.addHackable(WitchEntity.class, HackableWitch::new);
        manager.addHackable(EndermanEntity.class, HackableEnderman::new);
        manager.addHackable(BatEntity.class, HackableBat::new);
        manager.addHackable(HorseEntity.class, HackableHorse::new);
        manager.addHackable(ShulkerEntity.class, HackableShulker::new);
        manager.addHackable(GuardianEntity.class, HackableGuardian::new);
        manager.addHackable(VillagerEntity.class, HackableVillager::new);
        manager.addHackable(PaintingEntity.class, HackablePainting::new);
        manager.addHackable(ItemFrameEntity.class, HackableItemFrame::new);
    }

    public static IHackableEntity getHackableForEntity(Entity entity, PlayerEntity player) {
        HackableHandler.getInstance().trackedHackableEntities.entrySet().removeIf(entry -> !((Entity)entry.getKey()).func_70089_S() || !((IHackableEntity)entry.getValue()).canHack((Entity)entry.getKey(), player) && !HackableHandler.isInDisplayCooldown((IHackableEntity)entry.getValue(), (Entity)entry.getKey()));
        if (entity instanceof IHackableEntity && ((IHackableEntity)entity).canHack(entity, player)) {
            return (IHackableEntity)entity;
        }
        IHackableEntity hackable = HackableHandler.getInstance().trackedHackableEntities.get(entity);
        if (hackable == null && (hackable = PneumaticHelmetRegistry.getInstance().getHackable(entity, player)) != null) {
            HackableHandler.getInstance().trackedHackableEntities.put(entity, hackable);
        }
        return hackable;
    }

    public static IHackableBlock getHackableForBlock(IBlockReader world, BlockPos pos, PlayerEntity player) {
        Block block = world.func_180495_p(pos).func_177230_c();
        HackableHandler.getInstance().trackedHackableBlocks.entrySet().removeIf(entry -> {
            Block trackedBlock = (Block)((Pair)entry.getValue()).getLeft();
            IHackableBlock hackableBlock = (IHackableBlock)((Pair)entry.getValue()).getRight();
            return block != trackedBlock || !hackableBlock.canHack(((WorldAndCoord)entry.getKey()).world, ((WorldAndCoord)entry.getKey()).pos, player) && !HackableHandler.isInDisplayCooldown(hackableBlock, ((WorldAndCoord)entry.getKey()).world, ((WorldAndCoord)entry.getKey()).pos, player);
        });
        if (block instanceof IHackableBlock && ((IHackableBlock)block).canHack(world, pos, player)) {
            return (IHackableBlock)block;
        }
        WorldAndCoord loc = new WorldAndCoord(world, pos);
        Pair pair = HackableHandler.getInstance().trackedHackableBlocks.get(loc);
        if (pair == null) {
            IHackableBlock hackable = PneumaticHelmetRegistry.getInstance().getHackable(block);
            if (hackable != null && hackable.canHack(world, pos, player)) {
                pair = Pair.of((Object)block, (Object)hackable);
                HackableHandler.getInstance().trackedHackableBlocks.put(loc, (Pair<Block, IHackableBlock>)pair);
            } else {
                return null;
            }
        }
        return (IHackableBlock)pair.getRight();
    }

    private static boolean isInDisplayCooldown(IHackableBlock hackableBlock, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            RenderBlockTarget target = HUDHandler.instance().getSpecificRenderer(BlockTrackUpgradeHandler.class).getTargetForCoord(pos);
            int requiredHackTime = hackableBlock.getHackTime(world, pos, player);
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }

    private static boolean isInDisplayCooldown(IHackableEntity hackableEntity, Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            RenderEntityTarget target = HUDHandler.instance().getSpecificRenderer(EntityTrackUpgradeHandler.class).getTargetForEntity(entity);
            int requiredHackTime = hackableEntity.getHackTime(entity, ClientUtils.getClientPlayer());
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }
}

