/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.List;
import me.desht.pneumaticcraft.common.block.tubes.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.block.tubes.TubeModuleRedstoneEmitting;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class ModuleFlowDetector
extends TubeModuleRedstoneEmitting
implements IInfluenceDispersing {
    public float rotation;
    public float oldRotation;
    private int flow;
    private int oldFlow;

    public ModuleFlowDetector(ItemTubeModule item) {
        super(item);
    }

    @Override
    public void update() {
        super.update();
        this.oldRotation = this.rotation;
        this.rotation += (float)this.getRedstoneLevel() / 100.0f;
        if (!this.pressureTube.func_145831_w().field_72995_K) {
            if (this.setRedstone(this.flow / 5)) {
                this.sendDescriptionPacket();
            }
            this.oldFlow = this.flow;
            this.flow = 0;
        }
    }

    @Override
    public int getMaxDispersion() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onAirDispersion(int amount) {
        this.flow += amount;
    }

    @Override
    public void addInfo(List<ITextComponent> curInfo) {
        super.addInfo(curInfo);
        curInfo.add(PneumaticCraftUtils.xlate("waila.flowModule.level", this.oldFlow));
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.rotation = tag.func_74760_g("rotation");
        this.oldFlow = tag.func_74762_e("flow");
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74776_a("rotation", this.rotation);
        tag.func_74768_a("flow", this.oldFlow);
    }

    @Override
    public boolean canUpgrade() {
        return false;
    }
}

