/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetExternalProgram;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class DroneAIExternalProgram
extends DroneAIBlockInteraction<ProgWidgetExternalProgram> {
    private final DroneAIManager subAI;
    private final DroneAIManager mainAI;
    private final Set<BlockPos> traversedPositions = new HashSet<BlockPos>();
    private int curSlot;
    private CompoundNBT curProgramTag;

    public DroneAIExternalProgram(IDroneBase drone, DroneAIManager mainAI, ProgWidgetExternalProgram widget) {
        super(drone, widget);
        this.mainAI = mainAI;
        this.subAI = new DroneAIManager(drone, new ArrayList<IProgWidget>());
    }

    @Override
    public boolean func_75250_a() {
        if (super.func_75250_a()) {
            this.traversedPositions.clear();
            return true;
        }
        return false;
    }

    @Override
    protected boolean moveToPositions() {
        return false;
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.traversedPositions.add(pos)) {
            this.curSlot = 0;
            TileEntity te = this.drone.world().func_175625_s(pos);
            return te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return (Boolean)IOHelper.getInventoryForTE(this.drone.world().func_175625_s(pos)).map(this::handleInv).orElse((Object)false);
    }

    private boolean handleInv(IItemHandler inv) {
        if (this.curProgramTag != null) {
            if (this.curSlot < inv.getSlots()) {
                ItemStack stack = inv.getStackInSlot(this.curSlot);
                if (this.curProgramTag.equals((Object)stack.func_77978_p())) {
                    this.subAI.onUpdateTasks();
                    if (this.subAI.isIdling() || this.isRunningSameProgram(this.subAI.getCurrentAI())) {
                        this.curProgramTag = null;
                        ++this.curSlot;
                    }
                } else {
                    this.curProgramTag = null;
                    this.subAI.setWidgets(new ArrayList<IProgWidget>());
                }
            }
            return true;
        }
        while (this.curSlot < inv.getSlots()) {
            List<IProgWidget> widgets;
            boolean areWidgetsValid;
            IProgrammable programmable;
            ItemStack stack = inv.getStackInSlot(this.curSlot);
            if (stack.func_77973_b() instanceof IProgrammable && (programmable = (IProgrammable)stack.func_77973_b()).canProgram(stack) && programmable.usesPieces(stack) && (areWidgetsValid = (widgets = TileEntityProgrammer.getProgWidgets(stack)).stream().allMatch(widget -> this.drone.isProgramApplicable(widget.getType())))) {
                if (((ProgWidgetExternalProgram)this.progWidget).shareVariables) {
                    this.mainAI.connectVariables(this.subAI);
                }
                this.subAI.getDrone().getAIManager().setLabel("Main");
                this.subAI.setWidgets(widgets);
                this.curProgramTag = stack.func_77978_p();
                if (!this.subAI.isIdling()) {
                    return true;
                }
            }
            ++this.curSlot;
        }
        return false;
    }

    private boolean isRunningSameProgram(Goal ai) {
        return ai instanceof DroneAIExternalProgram && this.curProgramTag.equals((Object)((DroneAIExternalProgram)ai).curProgramTag);
    }

    DroneAIManager getRunningAI() {
        return this.subAI;
    }
}

