/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;

public class DroneAIEnergyImport
extends DroneAIImExBase<ProgWidgetInventoryBase> {
    public DroneAIEnergyImport(IDroneBase drone, ProgWidgetInventoryBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return this.importEnergy(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.importEnergy(pos, true);
    }

    private boolean importEnergy(BlockPos pos, boolean simulate) {
        boolean didWork = false;
        if (this.droneIsFull()) {
            this.abort();
        } else {
            Direction face;
            TileEntity te = this.drone.world().func_175625_s(pos);
            if (te == null) {
                return false;
            }
            Direction[] directionArray = Direction.field_199792_n;
            int n = directionArray.length;
            for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(face = directionArray[i]) && (didWork = this.tryImportFromSide(te, face, simulate))); ++i) {
            }
        }
        return didWork;
    }

    private boolean tryImportFromSide(TileEntity te, Direction face, boolean simulate) {
        return (Boolean)te.getCapability(CapabilityEnergy.ENERGY, face).map(tileHandler -> {
            int toExtract = tileHandler.extractEnergy(this.useCount() ? this.getRemainingCount() : Integer.MAX_VALUE, true);
            int toTransfer = this.insertToDrone(toExtract, true);
            if (toTransfer > 0) {
                if (!simulate) {
                    this.decreaseCount(toTransfer);
                    tileHandler.extractEnergy(toTransfer, false);
                    this.insertToDrone(toTransfer, false);
                }
                return true;
            }
            return false;
        }).orElse((Object)false);
    }

    private int insertToDrone(int maxTransfer, boolean simulate) {
        return (Integer)this.drone.getCapability(CapabilityEnergy.ENERGY).map(h -> h.receiveEnergy(maxTransfer, simulate)).orElseThrow(RuntimeException::new);
    }

    private boolean droneIsFull() {
        return (Boolean)this.drone.getCapability(CapabilityEnergy.ENERGY).map(h -> h.getEnergyStored() == h.getMaxEnergyStored()).orElseThrow(RuntimeException::new);
    }
}

