/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;

public class RenderBlockTarget {
    private static final float STAT_SCALE = 0.02f;
    private final World world;
    private final BlockPos pos;
    public int ticksExisted = 0;
    public final WidgetAnimatedStat stat;
    private final PlayerEntity player;
    public List<String> textList = new ArrayList<String>();
    private int hackTime;
    private final BlockTrackUpgradeHandler blockTracker;
    private TileEntity te;
    private int nEntries;

    public RenderBlockTarget(World world, PlayerEntity player, BlockPos pos, TileEntity te, BlockTrackUpgradeHandler blockTracker) {
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.te = te;
        this.blockTracker = blockTracker;
        String title = world.func_180495_p(pos).func_177230_c().func_149739_a();
        BlockState state = world.func_180495_p(pos);
        ItemStack stack = state.func_177230_c().getPickBlock(state, Minecraft.func_71410_x().field_71476_x, (IBlockReader)world, pos, player);
        if (!stack.func_190926_b()) {
            title = stack.func_200301_q().func_150254_d();
        }
        this.stat = new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.of(stack), 20, -20, 0x4000AA00, null, false);
        this.stat.setMinDimensionsAndReset(0, 0);
    }

    public void setTileEntity(TileEntity te) {
        this.te = te;
    }

    public boolean isTargetStillValid() {
        return this.nEntries > 0;
    }

    private List<IBlockTrackEntry> getApplicableEntries() {
        return BlockTrackEntryList.instance.getEntriesForCoordinate((IBlockReader)this.world, this.pos, this.te);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public double getDistanceToEntity(Entity entity) {
        return Math.sqrt(entity.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5));
    }

    public void maybeRefreshFromServer(List<IBlockTrackEntry> applicableTrackEntries) {
        for (IBlockTrackEntry entry : applicableTrackEntries) {
            entry.getServerUpdatePositions(this.te).forEach(p -> NetworkHandler.sendToServer(new PacketDescriptionPacketRequest((BlockPos)p)));
        }
    }

    public void update() {
        if (this.te != null && this.te.func_145837_r()) {
            this.te = null;
        }
        this.stat.tickWidget();
        List<IBlockTrackEntry> applicableTrackEntries = this.getApplicableEntries();
        this.nEntries = applicableTrackEntries.size();
        if (this.world.func_82737_E() % 100L == 7L) {
            this.maybeRefreshFromServer(applicableTrackEntries);
        }
        if (!this.world.func_175623_d(this.pos)) {
            this.textList = new ArrayList<String>();
            if (this.ticksExisted > 120) {
                this.stat.closeWindow();
                for (IBlockTrackEntry entry : applicableTrackEntries) {
                    if (this.blockTracker.countBlockTrackersOfType(entry) > entry.spamThreshold()) continue;
                    this.stat.openWindow();
                    break;
                }
                if (this.isPlayerLookingAtTarget()) {
                    this.stat.openWindow();
                    this.addBlockTrackInfo(this.textList, applicableTrackEntries);
                }
                this.stat.setText(this.textList);
            } else if (this.ticksExisted < -30) {
                this.stat.closeWindow();
                this.stat.setText(this.textList);
            }
        }
        if (this.hackTime > 0) {
            IHackableBlock hackableBlock = HackableHandler.getHackableForBlock((IBlockReader)this.world, this.pos, this.player);
            this.hackTime = hackableBlock != null ? ++this.hackTime : 0;
        }
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        matrixStack.func_227860_a_();
        double x = (double)this.pos.func_177958_n() + 0.5;
        double y = (double)this.pos.func_177956_o() + 0.5;
        double z = (double)this.pos.func_177952_p() + 0.5;
        matrixStack.func_227861_a_(x, y, z);
        if (!this.world.func_175623_d(this.pos)) {
            this.renderBlockHighlight(matrixStack, buffer, this.world, this.pos, partialTicks);
        }
        RenderUtils.rotateToPlayerFacing(matrixStack);
        float targetAcquireProgress = ((float)this.ticksExisted + partialTicks) / 1.2f;
        if (this.ticksExisted > 50 && this.ticksExisted <= 120) {
            RenderProgressBar.render3d(matrixStack, buffer, 0.0, 0.4, 1.8, 0.7, 0.0, targetAcquireProgress, -788529408, -805241088);
        }
        matrixStack.func_227862_a_(0.02f, 0.02f, 0.02f);
        if (!this.world.func_175623_d(this.pos)) {
            if (this.ticksExisted > 120) {
                if (this.isPlayerLookingAtTarget()) {
                    float mul = this.getStatSizeMultiplier(MathHelper.func_76133_a((double)ClientUtils.getClientPlayer().func_70092_e(x, y, z)));
                    matrixStack.func_227862_a_(mul, mul, mul);
                    this.stat.render3d(matrixStack, buffer, partialTicks);
                }
            } else if (this.ticksExisted > 50) {
                RenderUtils.renderString3d("Acquiring Target...", 0.0f, 0.0f, -8421505, matrixStack, buffer, false, true);
                RenderUtils.renderString3d((int)targetAcquireProgress + "%", 37.0f, 24.0f, -16765184, matrixStack, buffer, false, true);
            } else if (this.ticksExisted < -30) {
                matrixStack.func_227862_a_(1.5f, 1.5f, 1.5f);
                this.stat.render3d(matrixStack, buffer, partialTicks);
                RenderUtils.renderString3d("Lost Target!", 0.0f, 0.0f, -65536, matrixStack, buffer, false, true);
            }
        }
        matrixStack.func_227865_b_();
    }

    private float getStatSizeMultiplier(double dist) {
        if (dist < 4.0) {
            return Math.max(0.3f, (float)(dist / 4.0));
        }
        if (dist < 10.0) {
            return 1.0f;
        }
        return (float)(dist / 10.0);
    }

    private void renderBlockHighlight(MatrixStack matrixStack, IRenderTypeBuffer buffer, World world, BlockPos pos, float partialTicks) {
        BlockState state = world.func_180495_p(pos);
        float progress = ((float)(world.func_82737_E() & 0x1FL) + partialTicks) / 32.0f;
        float cycle = MathHelper.func_76126_a((float)((float)((double)progress * Math.PI)));
        VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
        float shrink = (shape == VoxelShapes.func_197868_b() ? 0.05f : 0.0f) + cycle / 60.0f;
        AxisAlignedBB aabb = shape.func_197752_a().func_186664_h((double)shrink);
        float alpha = 0.5f;
        if (this.blockTracker.getFocusedPos() != null) {
            alpha = this.blockTracker.getFocusedPos().equals((Object)pos) ? 0.75f : 0.15f;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        RenderUtils.renderFrame(matrixStack, buffer, aabb, 0.015625f, 0.25f, 0.75f, 0.75f, alpha, 0xF000F0, true);
        matrixStack.func_227865_b_();
    }

    private boolean isInitialized() {
        return this.ticksExisted >= 120;
    }

    private void addBlockTrackInfo(List<String> textList, List<IBlockTrackEntry> entries) {
        entries.forEach(e -> e.addInformation(this.world, this.pos, this.te, this.isPlayerLookingAtTarget() ? this.blockTracker.getFocusedFace() : null, textList));
    }

    private boolean isPlayerLookingAtTarget() {
        return this.pos.equals((Object)this.blockTracker.getFocusedPos());
    }

    public void hack() {
        IHackableBlock block;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (block = HackableHandler.getHackableForBlock((IBlockReader)this.world, this.pos, this.player)) != null && (this.hackTime == 0 || this.hackTime > block.getHackTime((IBlockReader)this.world, this.pos, this.player))) {
            NetworkHandler.sendToServer(new PacketHackingBlockStart(this.pos));
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(InputEvent.MouseScrollEvent event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.mouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDelta());
        }
        return false;
    }
}

