/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.fluid;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.render.fluid.AbstractFluidTESR;
import me.desht.pneumaticcraft.client.render.fluid.IFluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.tileentity.TileEntityFluidTank;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class RenderFluidTank
extends AbstractFluidTESR<TileEntityFluidTank> {
    private static final AxisAlignedBB BOUNDS_NONE = new AxisAlignedBB(0.125, 0.063125, 0.125, 0.875, 0.936875, 0.875);
    private static final AxisAlignedBB BOUNDS_UP = new AxisAlignedBB(0.125, 0.063125, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB BOUNDS_DOWN = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.936875, 0.875);
    private static final AxisAlignedBB BOUNDS_BOTH = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public RenderFluidTank(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    List<TankRenderInfo> getTanksToRender(TileEntityFluidTank te) {
        boolean up = (Boolean)te.func_195044_w().func_177229_b((IProperty)BlockPneumaticCraft.UP);
        boolean down = (Boolean)te.func_195044_w().func_177229_b((IProperty)BlockPneumaticCraft.DOWN);
        AxisAlignedBB bounds = up && down ? BOUNDS_BOTH : (up ? BOUNDS_UP : (down ? BOUNDS_DOWN : BOUNDS_NONE));
        return Collections.singletonList(new FluidTankRenderInfo((IFluidTank)te.getTank(), bounds));
    }

    private static class FluidTankRenderInfo
    extends TankRenderInfo {
        FluidTankRenderInfo(IFluidTank tank, AxisAlignedBB bounds) {
            super(tank, bounds, new Direction[0]);
        }

        @Override
        public boolean shouldRender(Direction face) {
            switch (face) {
                case UP: {
                    return this.getTank().getFluid().getAmount() < this.getTank().getCapacity() && !this.getTank().getFluid().getFluid().getAttributes().isLighterThanAir();
                }
                case DOWN: {
                    return this.getTank().getFluid().getAmount() < this.getTank().getCapacity() && this.getTank().getFluid().getFluid().getAttributes().isLighterThanAir();
                }
            }
            return true;
        }
    }

    public static class ItemRenderInfoProvider
    implements IFluidItemRenderInfoProvider {
        @Override
        public List<TankRenderInfo> getTanksToRender(ItemStack stack) {
            return (List)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(h -> Collections.singletonList(new TankRenderInfo(h.getFluidInTank(0), h.getTankCapacity(0), BOUNDS_NONE, new Direction[0]))).orElse(Collections.emptyList());
        }
    }
}

