/*
 * Decompiled with CFR 0.152.
 */
package shadows.click;

import shadows.placebo.config.Configuration;

public class ClickMachineConfig {
    public static int[] speeds = new int[]{500, 200, 100, 50, 20, 10, 5, 2, 1};
    public static boolean usesRF = false;
    public static int maxPowerStorage = 50000;
    public static int[] powerPerSpeed = new int[]{0, 3, 5, 10, 25, 50, 100, 250, 500};
    public static int powerUpdateFreq = 10;

    public static void init(Configuration cfg) {
        int i;
        String[] def = new String[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            def[i2] = Integer.valueOf(speeds[i2]).toString();
        }
        String[] unparsed = cfg.getStringList("Speeds", "general", def, "The possible speeds of the auto clicker, from 0-8.  Must have 9 values.");
        for (i = 0; i < 9; ++i) {
            ClickMachineConfig.speeds[i] = Integer.parseInt(unparsed[i]);
        }
        usesRF = cfg.getBoolean("Uses RF", "general", usesRF, "If the auto clicker uses RF");
        def = new String[9];
        for (i = 0; i < 9; ++i) {
            def[i] = Integer.valueOf(powerPerSpeed[i]).toString();
        }
        unparsed = cfg.getStringList("RF Costs", "general", def, "The RF cost per tick for each speed, from 0-8.  Must have 9 values.  Unused if \"Uses RF\" = false");
        for (i = 0; i < 9; ++i) {
            ClickMachineConfig.powerPerSpeed[i] = Integer.parseInt(unparsed[i]);
        }
        maxPowerStorage = cfg.getInt("Max Power Storage", "general", maxPowerStorage, 0, Integer.MAX_VALUE, "How much power the auto clicker can store.  Also the max input rate.  Unused if \"Uses RF\" = false");
        powerUpdateFreq = cfg.getInt("Power Update Frequency", "general", 10, 1, Integer.MAX_VALUE, "How often, in ticks, the power value of the TE will be synced with the GUI.");
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }
}

