/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.entities;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.dimension.BzDimension;
import net.telepathicgrunt.bumblezone.dimension.BzDimensionRegistration;
import net.telepathicgrunt.bumblezone.effects.BzEffects;
import net.telepathicgrunt.bumblezone.effects.WrathOfTheHiveEffect;

@Mod.EventBusSubscriber(modid="the_bumblezone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BeeAggressionBehavior {

    @Mod.EventBusSubscriber(modid="the_bumblezone")
    private static class ForgeEvents {
        private static Set<EntityType<?>> SetOfBeeHatedEntities = new HashSet();

        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void SetupBeeHatingList(WorldEvent.Load event) {
            if (SetOfBeeHatedEntities.size() != 0) {
                return;
            }
            for (EntityType entityType : ForgeRegistries.ENTITIES) {
                Entity entity;
                if (entityType.func_220339_d() != EntityClassification.MONSTER && entityType.func_220339_d() != EntityClassification.CREATURE && entityType.func_220339_d() != EntityClassification.AMBIENT || !((entity = entityType.func_200721_a(event.getWorld().func_201672_e())) instanceof MobEntity)) continue;
                String mobName = entityType.getRegistryName().toString();
                MobEntity mobEntity = (MobEntity)entity;
                if ((mobEntity.func_70668_bt() != CreatureAttribute.field_223224_c_ || mobName.contains("bee")) && !(mobEntity instanceof PandaEntity) && !mobName.contains("bear")) continue;
                SetOfBeeHatedEntities.add(entityType);
            }
        }

        @SubscribeEvent
        public static void HoneyPickupEvent(PlayerEvent.ItemPickupEvent event) {
            PlayerEntity playerEntity = event.getPlayer();
            if (!(playerEntity.field_70170_p.field_72995_K || event.getStack().func_77973_b() != Items.field_226639_pY_ || playerEntity.field_71093_bK != BzDimensionRegistration.bumblezone() && !Bumblezone.BzConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue() || playerEntity.func_184812_l_() || playerEntity.func_175149_v() || !Bumblezone.BzConfig.aggressiveBees.get().booleanValue())) {
                playerEntity.func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
            }
        }

        @SubscribeEvent
        public static void HoneyDrinkEvent(LivingEntityUseItemEvent.Finish event) {
            if (!event.getEntity().field_70170_p.field_72995_K && event.getItem().func_77973_b() == Items.field_226638_pX_ && event.getEntity() instanceof PlayerEntity) {
                PlayerEntity playerEntity = (PlayerEntity)event.getEntity();
                if ((playerEntity.field_71093_bK == BzDimensionRegistration.bumblezone() || Bumblezone.BzConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v() && Bumblezone.BzConfig.aggressiveBees.get().booleanValue()) {
                    playerEntity.func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
                }
            }
        }

        @SubscribeEvent
        public static void MobHitEvent(LivingHurtEvent event) {
            Entity entity = event.getEntity();
            Entity attackerEntity = event.getSource().func_76346_g();
            if (!entity.field_70170_p.field_72995_K && (entity.field_71093_bK == BzDimensionRegistration.bumblezone() || Bumblezone.BzConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && Bumblezone.BzConfig.aggressiveBees.get().booleanValue() && entity instanceof BeeEntity && attackerEntity != null) {
                if (attackerEntity instanceof PlayerEntity && !((PlayerEntity)attackerEntity).func_184812_l_() && !((PlayerEntity)attackerEntity).func_175149_v()) {
                    ((PlayerEntity)attackerEntity).func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
                } else if (attackerEntity instanceof MobEntity) {
                    ((MobEntity)attackerEntity).func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, true));
                }
            }
        }

        @SubscribeEvent
        public static void MobUpdateEvent(LivingEvent.LivingUpdateEvent event) {
            Entity entity = event.getEntity();
            if (!entity.field_70170_p.field_72995_K && entity.field_71093_bK == BzDimensionRegistration.bumblezone() && Bumblezone.BzConfig.aggressiveBees.get().booleanValue() && entity instanceof MobEntity) {
                MobEntity mobEntity = (MobEntity)entity;
                if (SetOfBeeHatedEntities.contains(entity.func_200600_R()) && !mobEntity.func_70644_a(BzEffects.WRATH_OF_THE_HIVE)) {
                    ((MobEntity)entity).func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzConfig.howLongWrathOfTheHiveLasts.get().intValue(), 1, false, true));
                }
            }
        }

        @SubscribeEvent
        public static void playerTick(TickEvent.PlayerTickEvent event) {
            PlayerEntity playerEntity = event.player;
            if (!playerEntity.field_70170_p.field_72995_K && playerEntity.func_70644_a(BzEffects.WRATH_OF_THE_HIVE) && !Bumblezone.BzConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue() && playerEntity.field_71093_bK != BzDimensionRegistration.bumblezone()) {
                playerEntity.func_195063_d(BzEffects.WRATH_OF_THE_HIVE);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.field_70170_p, (LivingEntity)playerEntity);
            }
            Boolean wrathEffect = playerEntity.func_70644_a(BzEffects.WRATH_OF_THE_HIVE);
            if (!BzDimension.ACTIVE_WRATH && wrathEffect.booleanValue()) {
                BzDimension.ACTIVE_WRATH = true;
            } else if (BzDimension.ACTIVE_WRATH && !wrathEffect.booleanValue()) {
                WrathOfTheHiveEffect.calmTheBees(playerEntity.field_70170_p, (LivingEntity)playerEntity);
                BzDimension.ACTIVE_WRATH = false;
            }
        }
    }
}

